/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCopiedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCreatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeDeletedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.model.querydsl.QNodeAssociation;
import com.atlassian.jira.model.querydsl.QWorkflowScheme;
import com.atlassian.jira.model.querydsl.QWorkflowSchemeEntity;
import com.atlassian.jira.model.querydsl.WorkflowSchemeEntityDTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Streams;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeBuilder;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeStore;
import com.atlassian.jira.workflow.DefaultWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowSchemeBuilder;
import com.atlassian.jira.workflow.DraftWorkflowSchemeImpl;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.SchemeIsBeingMigratedException;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeImpl;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowSchemes;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class EagerWorkflowSchemeManager
extends AbstractSchemeManager
implements WorkflowSchemeManager,
Startable {
    private static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.EagerWorkflowSchemeManager.caches.request";
    private static final Logger log = LoggerFactory.getLogger(EagerWorkflowSchemeManager.class);
    private static final String ALL_ISSUE_TYPES = "0";
    private static final String SCHEME_ENTITY_NAME = "WorkflowScheme";
    private static final String WORKFLOW_ENTITY_NAME = "WorkflowSchemeEntity";
    private static final String SCHEME_DESC = "Workflow";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.workflows.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.workflows.default.desc";
    private static final String COLUMN_ISSUETYPE = "issuetype";
    private static final String COLUMN_WORKFLOW = "workflow";
    private static final ThreadLocal<Boolean> UPDATED_WORKFLOW_SCHEME_FIRE_EVENT = ThreadLocal.withInitial(() -> true);
    private final AssignableWorkflowScheme defaultScheme;
    private final WorkflowManager workflowManager;
    private final ConstantsManager constantsManager;
    private final OfBizDelegator ofBizDelegator;
    private final DraftWorkflowSchemeStore draftWorkflowSchemeStore;
    private final UserManager userManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final AssignableWorkflowSchemeStore assignableWorkflowSchemeStore;
    private final ClusterLockService clusterLockService;
    private final QueryDslAccessor queryDslAccessor;
    private final CachedReference<WorkflowSchemeEntitiesCache> cache;

    public EagerWorkflowSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, WorkflowManager workflowManager, ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, NodeAssociationStore nodeAssociationStore, GroupManager groupManager, DraftWorkflowSchemeStore draftWorkflowSchemeStore, JiraAuthenticationContext context, UserManager userManager, I18nHelper.BeanFactory i18nFactory, AssignableWorkflowSchemeStore assignableWorkflowSchemeStore, CacheManager cacheManager, ClusterLockService clusterLockService, QueryDslAccessor queryDslAccessor) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, ofBizDelegator, groupManager, eventPublisher, cacheManager);
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
        this.ofBizDelegator = ofBizDelegator;
        this.draftWorkflowSchemeStore = draftWorkflowSchemeStore;
        this.userManager = userManager;
        this.i18nFactory = i18nFactory;
        this.assignableWorkflowSchemeStore = assignableWorkflowSchemeStore;
        this.clusterLockService = clusterLockService;
        this.defaultScheme = new DefaultWorkflowScheme(context);
        this.queryDslAccessor = queryDslAccessor;
        this.cache = cacheManager.getCachedReference(this.getClass().getName() + ".cache", this::loadAllWorkflowSchemeEntities);
    }

    public void start() {
        this.clearWorkflowCache();
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        try {
            super.onClearCache(event);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return WORKFLOW_ENTITY_NAME;
    }

    public void clearWorkflowCache() {
        this.cache.reset();
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    public GenericValue getWorkflowScheme(GenericValue project) throws GenericEntityException {
        return EntityUtil.getOnly(this.getSchemes(project));
    }

    public GenericValue getWorkflowScheme(Project project) throws GenericEntityException {
        return this.getWorkflowScheme(project.getGenericValue());
    }

    private Map<String, String> toWorkflowMap(Collection<WorkflowSchemeEntityDTO> related) {
        return related.stream().filter(dto -> dto.getIssuetype() != null).collect(Collectors.toMap(dto -> ALL_ISSUE_TYPES.equals(dto.getIssuetype()) ? null : dto.getIssuetype(), WorkflowSchemeEntityDTO::getWorkflow));
    }

    public boolean hasDraft(@Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        return !scheme.isDefault() && scheme.getId() != null && this.draftWorkflowSchemeStore.hasDraftForParent(scheme.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public AssignableWorkflowScheme createScheme(@Nonnull AssignableWorkflowScheme workflowScheme) {
        AssignableWorkflowSchemeStore.AssignableState savedState;
        Assertions.notNull((String)"wokflowScheme", (Object)workflowScheme);
        try {
            AssignableWorkflowSchemeStore.AssignableState.Builder builder = this.assignableWorkflowSchemeStore.builder();
            builder.setName(workflowScheme.getName()).setDescription(workflowScheme.getDescription()).setMappings(workflowScheme.getMappings());
            savedState = this.assignableWorkflowSchemeStore.create(builder.build());
        }
        finally {
            this.clearWorkflowCache();
        }
        this.eventPublisher.publish((Object)this.createSchemeCreatedEvent(this.getSchemeObject(savedState.getId())));
        return EagerWorkflowSchemeManager.toWorkflowScheme(savedState);
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        return this.createSchemeEntity(scheme.getLong("id"), schemeEntity);
    }

    @Override
    protected GenericValue createSchemeEntityNoEvent(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        return this.createSchemeEntity(scheme.getLong("id"), schemeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericValue createSchemeEntity(long schemeId, SchemeEntity schemeEntity) throws GenericEntityException {
        Assertions.is((String)"Workflow scheme IDs must be String values", (boolean)(schemeEntity.getEntityTypeId() instanceof String));
        try {
            GenericValue genericValue = EntityUtils.createValue(this.getEntityName(), (Map<String, Object>)FieldMap.build((String)"scheme", (Object)schemeId, (String)COLUMN_WORKFLOW, (Object)schemeEntity.getType(), (String)COLUMN_ISSUETYPE, (Object)schemeEntity.getEntityTypeId().toString()));
            return genericValue;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    public List<GenericValue> getEntities(GenericValue scheme, String issuetype) throws GenericEntityException {
        WorkflowSchemeEntityDTO value = ((WorkflowSchemeEntitiesCache)this.cache.get()).getByWorkflowId(EagerWorkflowSchemeManager.getCacheKeyForScheme(scheme)).get(issuetype);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value.toGenericValue(this.ofBizDelegator));
    }

    public Map<String, String> getWorkflowMap(Project project) {
        return this.getWorkflowMap(((WorkflowSchemeEntitiesCache)this.cache.get()).getWorkflowIdForProject(project.getId()));
    }

    @VisibleForTesting
    Map<String, String> getWorkflowMap(Long schemeId) {
        if (schemeId == null) {
            return MapBuilder.build(null, (Object)"jira");
        }
        return this.toWorkflowMap(((WorkflowSchemeEntitiesCache)this.cache.get()).getByWorkflowId(schemeId).values());
    }

    public String getWorkflowName(Project project, String issueTypeId) {
        return this.getWorkflowName(((WorkflowSchemeEntitiesCache)this.cache.get()).getWorkflowIdForProject(project.getId()), issueTypeId);
    }

    public String getWorkflowName(GenericValue scheme, String issueTypeId) {
        if (scheme != null) {
            return this.getWorkflowName(scheme.getLong("id"), issueTypeId);
        }
        return "jira";
    }

    private String getWorkflowName(Long schemeId, String issueType) {
        if (schemeId != null) {
            Map<String, WorkflowSchemeEntityDTO> map = ((WorkflowSchemeEntitiesCache)this.cache.get()).getByWorkflowId(schemeId);
            WorkflowSchemeEntityDTO value = map.get(issueType);
            if (value == null) {
                value = map.get(ALL_ISSUE_TYPES);
            }
            if (value != null) {
                return value.getWorkflow();
            }
        }
        return "jira";
    }

    public boolean isUsingDefaultScheme(Project project) {
        return ((WorkflowSchemeEntitiesCache)this.cache.get()).getWorkflowIdForProject(project.getId()) == null;
    }

    @VisibleForTesting
    GenericValue getSchemeForProject(Project project) {
        return this.getSchemeForProject(project.getGenericValue());
    }

    @VisibleForTesting
    private GenericValue getSchemeForProject(GenericValue project) {
        try {
            return EntityUtil.getOnly(this.getSchemes(project));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static Long getCacheKeyForScheme(GenericValue scheme) {
        return scheme.getLong("id");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId, String parameter) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public GenericValue getDefaultEntity(GenericValue scheme) throws GenericEntityException {
        return EntityUtil.getOnly(this.getEntities(scheme, ALL_ISSUE_TYPES));
    }

    public AssignableWorkflowScheme getDefaultWorkflowScheme() {
        return this.defaultScheme;
    }

    public List<GenericValue> getNonDefaultEntities(GenericValue scheme) throws GenericEntityException {
        return this.getEntities(scheme).stream().filter(gv -> !ALL_ISSUE_TYPES.equals(gv.getString(COLUMN_ISSUETYPE))).collect(Collectors.toList());
    }

    public Collection<String> getActiveWorkflowNames() throws GenericEntityException, WorkflowException {
        return ((WorkflowSchemeEntitiesCache)this.cache.get()).getActiveWorkflows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowToScheme(GenericValue scheme, String workflowName, String issueTypeId) throws GenericEntityException {
        try {
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            if (this.getEntities(scheme, issueTypeId).isEmpty()) {
                this.createSchemeEntity(scheme, schemeEntity);
            }
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Nonnull
    public DraftWorkflowScheme createDraftOf(ApplicationUser creator, @Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        Assertions.not((String)"workflowScheme.default", (boolean)workflowScheme.isDefault());
        Assertions.notNull((String)"workflowScheme.id", (Object)workflowScheme.getId());
        Assertions.not((String)"scheme already has draft.", (boolean)this.hasDraft(workflowScheme));
        DraftWorkflowSchemeStore.DraftState.Builder builder = this.draftWorkflowSchemeStore.builder(workflowScheme.getId());
        builder.setMappings(workflowScheme.getMappings());
        builder.setLastModifiedUser(creator != null ? creator.getKey() : null);
        DraftWorkflowSchemeStore.DraftState state = this.draftWorkflowSchemeStore.create(builder.build());
        return this.toWorkflowScheme(state);
    }

    @Nonnull
    public DraftWorkflowScheme createDraft(ApplicationUser creator, @Nonnull DraftWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        AssignableWorkflowScheme parentScheme = workflowScheme.getParentScheme();
        Assertions.notNull((String)"workflowScheme.parentScheme", (Object)parentScheme);
        Assertions.notNull((String)"workflowScheme.parentScheme.id", (Object)parentScheme.getId());
        Assertions.not((String)"scheme already has draft.", (boolean)this.hasDraft(parentScheme));
        DraftWorkflowSchemeStore.DraftState.Builder builder = this.draftWorkflowSchemeStore.builder(parentScheme.getId());
        builder.setMappings(workflowScheme.getMappings());
        builder.setLastModifiedUser(ApplicationUsers.getKeyFor(creator));
        DraftWorkflowSchemeStore.DraftState state = this.draftWorkflowSchemeStore.create(builder.build());
        return this.toWorkflowScheme(state);
    }

    @Nonnull
    public Collection<AssignableWorkflowScheme> getAssignableSchemes() {
        Iterable workflowSchemes = Streams.stream(this.assignableWorkflowSchemeStore.getAll()).map(this.toAssignableFunction()).collect(Collectors.toList());
        return WorkflowSchemes.nameOrdering().immutableSortedCopy(workflowSchemes);
    }

    public void updateSchemesForRenamedWorkflow(String oldWorkflowName, String newWorkflowName) {
        Assertions.notBlank((String)"oldWorkflowName", (String)oldWorkflowName);
        Assertions.notBlank((String)"newWorkflowName", (String)newWorkflowName);
        try {
            this.ofBizDelegator.bulkUpdateByAnd(this.getEntityName(), (Map)ImmutableMap.of((Object)COLUMN_WORKFLOW, (Object)newWorkflowName), (Map)ImmutableMap.of((Object)COLUMN_WORKFLOW, (Object)oldWorkflowName));
            this.draftWorkflowSchemeStore.renameWorkflow(oldWorkflowName, newWorkflowName);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    public Collection<GenericValue> getSchemesForWorkflow(JiraWorkflow workflow) {
        LinkedList<GenericValue> schemes = new LinkedList<GenericValue>();
        HashSet<Long> schemeIds = new HashSet<Long>();
        List schemeEntities = ((WorkflowSchemeEntitiesCache)this.cache.get()).getAllEntities().stream().filter(dto -> workflow.getName().equals(dto.getWorkflow())).collect(Collectors.toList());
        for (WorkflowSchemeEntityDTO schemeEntity : schemeEntities) {
            Long schemeId = schemeEntity.getScheme();
            if (!schemeIds.add(schemeId)) continue;
            schemes.add(this.getScheme(schemeId));
        }
        return schemes;
    }

    public Iterable<WorkflowScheme> getSchemesForWorkflowIncludingDrafts(JiraWorkflow workflow) {
        if (workflow.isSystemWorkflow()) {
            throw new IllegalArgumentException("Can't get schemes for system workflow");
        }
        return Stream.concat(this.getSchemesForWorkflow(workflow).stream().map(this::toWorkflowScheme), Streams.stream(this.draftWorkflowSchemeStore.getSchemesUsingWorkflow(workflow)).map(this::toWorkflowScheme)).collect(Collectors.toList());
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        this.deleteEntities(Collections.singleton(id));
    }

    @Override
    public void deleteEntities(Iterable<Long> ids) {
        this.acquireLocksAndExecute(ids, WorkflowAction.DELETE_ENTITY, () -> {
            try {
                EagerWorkflowSchemeManager.super.deleteEntities(ids);
            }
            finally {
                this.clearWorkflowCache();
            }
        });
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private void acquireLocksAndExecute(Iterable<Long> ids, WorkflowAction lockType, Runnable action) {
        if (Iterables.isEmpty(ids)) {
            action.run();
        } else {
            TreeSet sortedIds = Sets.newTreeSet(ids);
            ManagedLocks.manage((Lock)this.getLock((Long)Iterables.getFirst((Iterable)sortedIds, null), lockType)).withLock(() -> this.acquireLocksAndExecute(Iterables.skip((Iterable)sortedIds, (int)1), lockType, action));
        }
    }

    private ClusterLock getLock(Long id, WorkflowAction action) {
        return this.clusterLockService.getLockForName(action.getLockName(id));
    }

    @Override
    protected SchemeEntity makeSchemeEntity(GenericValue entity) {
        return new SchemeEntity(entity.getString(COLUMN_WORKFLOW), (Object)entity.getString(COLUMN_ISSUETYPE));
    }

    @Override
    protected Object createSchemeEntityDeletedEvent(GenericValue entity) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    protected AbstractSchemeEvent createSchemeCreatedEvent(Scheme scheme) {
        return new WorkflowSchemeCreatedEvent(scheme);
    }

    @Override
    @Nonnull
    protected AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme oldScheme, @Nonnull Scheme newScheme) {
        return new WorkflowSchemeCopiedEvent(oldScheme, newScheme);
    }

    @Override
    public void deleteScheme(Long id) {
        if (id == null) {
            return;
        }
        ManagedLocks.manage((Lock)this.getLock(id, WorkflowAction.DELETE_SCHEME)).withLock(() -> this.doDeleteScheme(this.getWorkflowSchemeObj(id)));
    }

    @Override
    @Nonnull
    protected AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme scheme, Project project) {
        return new WorkflowSchemeAddedToProjectEvent(scheme, project);
    }

    void doDeleteScheme(AssignableWorkflowScheme scheme) {
        try {
            this.checkMigration(scheme);
            try {
                super.deleteScheme(scheme.getId());
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
            this.draftWorkflowSchemeStore.deleteByParentId(scheme.getId());
        }
        finally {
            this.clearWorkflowCache();
        }
        this.eventPublisher.publish((Object)new WorkflowSchemeDeletedEvent(scheme.getId(), scheme.getName()));
    }

    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    private Collection<IssueType> getAllIssueTypes() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    private JiraWorkflow getWorkflowFromScheme(GenericValue workflowScheme, String issueTypeId) {
        return this.workflowManager.getWorkflowFromScheme(workflowScheme, issueTypeId);
    }

    @Nullable
    public AssignableWorkflowScheme getWorkflowSchemeObj(long id) {
        return this.toWorkflowScheme(this.getScheme(id));
    }

    public AssignableWorkflowScheme getWorkflowSchemeObj(String name) {
        return this.toWorkflowScheme(this.getScheme(name));
    }

    public DraftWorkflowScheme getDraftForParent(@Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (scheme.isDefault() || scheme.getId() == null) {
            return null;
        }
        return this.getDraftForParent(scheme.getId());
    }

    private DraftWorkflowScheme getDraftForParent(long parentId) {
        return this.toWorkflowScheme(this.draftWorkflowSchemeStore.getDraftForParent(parentId));
    }

    public DraftWorkflowScheme getDraft(long id) {
        return this.toWorkflowScheme((DraftWorkflowSchemeStore.DraftState)this.draftWorkflowSchemeStore.get(id));
    }

    public AssignableWorkflowScheme getParentForDraft(long draftSchemeId) {
        return this.getWorkflowSchemeObj(this.draftWorkflowSchemeStore.getParentId(draftSchemeId));
    }

    public boolean isActive(@Nonnull WorkflowScheme scheme) {
        if (((WorkflowScheme)Assertions.notNull((String)"scheme", (Object)scheme)).isDraft()) {
            return false;
        }
        return ((WorkflowSchemeEntitiesCache)this.cache.get()).isWorkflowActive(scheme.getId()) || scheme.equals(this.defaultScheme) && ((WorkflowSchemeEntitiesCache)this.cache.get()).isDefaultWorkflowActive();
    }

    public boolean deleteWorkflowScheme(@Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.not((String)"scheme.default", (boolean)scheme.isDefault());
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        long lockSchemeId = scheme.isDraft() ? ((DraftWorkflowScheme)scheme).getParentScheme().getId().longValue() : scheme.getId().longValue();
        ClusterLock lock = this.getLock(lockSchemeId, WorkflowAction.DELETE_WORKFLOW_SCHEME);
        return (Boolean)ManagedLocks.manage((Lock)lock).withLock(() -> {
            if (scheme.isDraft()) {
                DraftWorkflowScheme draftScheme = (DraftWorkflowScheme)scheme;
                WorkflowSchemeMigrationTaskAccessor taskAccessor = this.getTaskAccessor();
                if (taskAccessor.getActiveByProjects(draftScheme, true, true) != null) {
                    throw new SchemeIsBeingMigratedException();
                }
                return this.draftWorkflowSchemeStore.delete(scheme.getId());
            }
            Assertions.not((String)"Cannot delete active scheme.", (boolean)this.isActive(scheme));
            this.doDeleteScheme((AssignableWorkflowScheme)scheme);
            return true;
        });
    }

    private void checkMigration(AssignableWorkflowScheme scheme) {
        if (scheme == null) {
            return;
        }
        WorkflowSchemeMigrationTaskAccessor taskAccessor = this.getTaskAccessor();
        if (taskAccessor.getActive((WorkflowScheme)scheme) != null) {
            throw new SchemeIsBeingMigratedException();
        }
    }

    public DraftWorkflowScheme updateDraftWorkflowScheme(ApplicationUser user, @Nonnull DraftWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        ClusterLock lock = this.getLock(scheme.getParentScheme().getId(), WorkflowAction.UPDATE_DRAFT_WORKFLOW_SCHEME);
        return (DraftWorkflowScheme)ManagedLocks.manage((Lock)lock).withLock(() -> {
            WorkflowSchemeMigrationTaskAccessor taskAccessor = this.getTaskAccessor();
            if (taskAccessor.getActiveByProjects(scheme, true) != null) {
                throw new SchemeIsBeingMigratedException();
            }
            DraftWorkflowSchemeStore.DraftState savedState = (DraftWorkflowSchemeStore.DraftState)this.draftWorkflowSchemeStore.get(scheme.getId());
            Assertions.notNull((String)String.format("scheme with id %d does not exist.", scheme.getId()), (Object)savedState);
            DraftWorkflowSchemeStore.DraftState.Builder builder = savedState.builder();
            builder.setMappings(scheme.getMappings());
            builder.setLastModifiedUser(user == null ? null : user.getKey());
            return this.toWorkflowScheme(this.draftWorkflowSchemeStore.update(builder.build()));
        });
    }

    public AssignableWorkflowScheme updateWorkflowScheme(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"scheme", (Object)workflowScheme);
        Assertions.notNull((String)"scheme.id", (Object)workflowScheme.getId());
        ClusterLock lock = this.getLock(workflowScheme.getId(), WorkflowAction.UPDATE_WORKFLOW_SCHEME);
        return (AssignableWorkflowScheme)ManagedLocks.manage((Lock)lock).withLock(() -> {
            UPDATED_WORKFLOW_SCHEME_FIRE_EVENT.set(false);
            try {
                this.checkMigration(workflowScheme);
                Scheme originalScheme = this.getSchemeObject(workflowScheme.getId());
                for (SchemeEntity entity : originalScheme.getEntities()) {
                    this.deleteEntity(entity.getId());
                }
                this.doUpdateScheme(new Scheme(workflowScheme.getId(), this.getSchemeEntityName(), workflowScheme.getName(), workflowScheme.getDescription(), Collections.emptyList()));
                this.createSchemeEntities(workflowScheme);
                this.eventPublisher.publish((Object)this.createSchemeUpdatedEvent(this.getSchemeObject(workflowScheme.getId()), originalScheme));
                AssignableWorkflowScheme assignableWorkflowScheme = this.getWorkflowSchemeObj(workflowScheme.getId());
                return assignableWorkflowScheme;
            }
            finally {
                UPDATED_WORKFLOW_SCHEME_FIRE_EVENT.remove();
            }
        });
    }

    @Override
    public void updateScheme(Scheme scheme) throws DataAccessException {
        ManagedLocks.manage((Lock)this.getLock(scheme.getId(), WorkflowAction.UPDATE_SCHEME)).withLock(() -> {
            AssignableWorkflowScheme schemeObj = this.toWorkflowScheme(this.getScheme(scheme.getId()));
            this.checkMigration(schemeObj);
            this.doUpdateScheme(scheme);
        });
    }

    @Override
    @Nonnull
    protected AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme scheme, Project project) {
        return new WorkflowSchemeRemovedFromProjectEvent(scheme, project);
    }

    @Override
    protected AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme scheme, Scheme originalScheme) {
        return new WorkflowSchemeUpdatedEvent(scheme, originalScheme);
    }

    private void doUpdateScheme(Scheme scheme) {
        try {
            super.updateScheme(scheme);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    WorkflowSchemeMigrationTaskAccessor getTaskAccessor() {
        return (WorkflowSchemeMigrationTaskAccessor)ComponentAccessor.getComponent(WorkflowSchemeMigrationTaskAccessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T waitForUpdatesToFinishAndExecute(AssignableWorkflowScheme scheme, Callable<T> task) throws Exception {
        if (scheme == null || scheme.getId() == null) {
            return task.call();
        }
        ArrayList locks = Lists.newArrayList();
        try {
            for (WorkflowAction action : WorkflowAction.values()) {
                ClusterLock lock = this.getLock(scheme.getId(), action);
                lock.lock();
                locks.add(lock);
            }
            T t = task.call();
            return t;
        }
        finally {
            this.unlockAll(locks);
        }
    }

    private void unlockAll(Collection<Lock> locks) {
        ArrayList exceptions = Lists.newArrayList();
        for (Lock lock : locks) {
            try {
                lock.unlock();
            }
            catch (RuntimeException ex) {
                exceptions.add(ex);
                log.error("Error releasing lock " + lock, (Throwable)ex);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (RuntimeException)exceptions.iterator().next();
        }
    }

    private void createSchemeEntities(AssignableWorkflowScheme workflowScheme) {
        for (Map.Entry mappingEntry : workflowScheme.getMappings().entrySet()) {
            String issueTypeId = (String)mappingEntry.getKey();
            if (issueTypeId == null) {
                issueTypeId = ALL_ISSUE_TYPES;
            }
            String workflowName = (String)mappingEntry.getValue();
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            try {
                this.createSchemeEntity(workflowScheme.getId(), schemeEntity);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    @Nonnull
    public AssignableWorkflowScheme getWorkflowSchemeObj(@Nonnull Project project) {
        Assertions.notNull((String)"project", (Object)project);
        GenericValue schemeForProject = this.getSchemeForProject(project);
        if (schemeForProject != null) {
            return this.toWorkflowScheme(schemeForProject);
        }
        return this.defaultScheme;
    }

    @Nonnull
    public List<Project> getProjectsUsing(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        ImmutableList.Builder projects = new ImmutableList.Builder();
        for (Project project : this.projectManager.getProjectObjects()) {
            GenericValue schemeForProject = this.getSchemeForProject(project);
            if (schemeForProject == null) {
                if (!workflowScheme.isDefault()) continue;
                projects.add((Object)project);
                continue;
            }
            Long id = schemeForProject.getLong("id");
            if (id == null || !id.equals(workflowScheme.getId())) continue;
            projects.add((Object)project);
        }
        return projects.build();
    }

    public AssignableWorkflowScheme cleanUpSchemeDraft(Project project, ApplicationUser user) {
        AssignableWorkflowScheme workflowScheme = this.getWorkflowSchemeObj(project);
        if (workflowScheme.isDefault()) {
            return null;
        }
        List<Project> projectsUsing = this.getProjectsUsing(workflowScheme);
        if (projectsUsing.size() > 1) {
            return null;
        }
        DraftWorkflowScheme draft = this.getDraftForParent(workflowScheme);
        if (draft == null) {
            return null;
        }
        AssignableWorkflowScheme.Builder copyOfDraftBuilder = (AssignableWorkflowScheme.Builder)new AssignableWorkflowSchemeBuilder().setName(this.getNameForCopy((WorkflowScheme)draft)).setDescription(this.getDescriptionForCopy(user, workflowScheme)).setMappings(draft.getMappings());
        AssignableWorkflowScheme scheme = this.createScheme(copyOfDraftBuilder.build());
        this.deleteWorkflowScheme((WorkflowScheme)draft);
        return scheme;
    }

    public AssignableWorkflowScheme copyDraft(DraftWorkflowScheme draft, ApplicationUser user, String newDescription) {
        AssignableWorkflowScheme.Builder copyOfDraftBuilder = (AssignableWorkflowScheme.Builder)new AssignableWorkflowSchemeBuilder().setName(this.getNameForCopy((WorkflowScheme)draft)).setDescription(newDescription).setMappings(draft.getMappings());
        return this.createScheme(copyOfDraftBuilder.build());
    }

    private String getNameForCopy(WorkflowScheme scheme) {
        return this.getNameForCopy(scheme.getName(), 255);
    }

    public void replaceSchemeWithDraft(DraftWorkflowScheme draft) {
        AssignableWorkflowScheme parentScheme = ((AssignableWorkflowScheme.Builder)this.getParentForDraft(draft.getId()).builder().setMappings(draft.getMappings())).build();
        this.updateWorkflowScheme(parentScheme);
        this.deleteWorkflowScheme((WorkflowScheme)draft);
    }

    public AssignableWorkflowScheme.Builder assignableBuilder() {
        return new AssignableWorkflowSchemeBuilder();
    }

    public DraftWorkflowScheme.Builder draftBuilder(AssignableWorkflowScheme parent) {
        Assertions.notNull((String)"parent", (Object)parent);
        Assertions.notNull((String)"parent.id", (Object)parent.getId());
        return new DraftWorkflowSchemeBuilder(parent);
    }

    String getDescriptionForCopy(ApplicationUser user, AssignableWorkflowScheme workflowScheme) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)workflowScheme.getDescription())) {
            sb.append(workflowScheme.getDescription()).append(" ");
        }
        sb.append(this.i18nFactory.getInstance(user).getText("admin.workflowschemes.manager.draft.auto.generated", workflowScheme.getName()));
        return sb.toString();
    }

    private AssignableWorkflowScheme toWorkflowScheme(GenericValue genericValue) {
        if (genericValue == null) {
            return null;
        }
        String name = genericValue.getString("name");
        String description = genericValue.getString("description");
        Long id = genericValue.getLong("id");
        Map<String, String> map = this.getWorkflowMap(id);
        return new WorkflowSchemeImpl(id, name, description, map);
    }

    private Function<AssignableWorkflowSchemeStore.AssignableState, AssignableWorkflowScheme> toAssignableFunction() {
        return EagerWorkflowSchemeManager::toWorkflowScheme;
    }

    private DraftWorkflowScheme toWorkflowScheme(DraftWorkflowSchemeStore.DraftState state) {
        if (state == null) {
            return null;
        }
        ApplicationUser userByKey = this.userManager.getUserByKey(state.getLastModifiedUser());
        return new DraftWorkflowSchemeImpl(state, userByKey, this.getWorkflowSchemeObj(state.getParentSchemeId()));
    }

    private static AssignableWorkflowScheme toWorkflowScheme(AssignableWorkflowSchemeStore.AssignableState state) {
        if (state == null) {
            return null;
        }
        return new WorkflowSchemeImpl(state);
    }

    @Override
    public GenericValue copyScheme(GenericValue oldScheme) throws GenericEntityException {
        try {
            GenericValue genericValue = super.copyScheme(oldScheme);
            return genericValue;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public Scheme copyScheme(Scheme oldScheme) {
        try {
            Scheme scheme = super.copyScheme(oldScheme);
            return scheme;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void updateScheme(GenericValue entity) throws GenericEntityException {
        try {
            if (UPDATED_WORKFLOW_SCHEME_FIRE_EVENT.get().booleanValue()) {
                super.updateScheme(entity);
            } else {
                entity.store();
                this.flushProjectSchemes();
            }
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void removeSchemesFromProject(Project project) throws DataAccessException {
        try {
            super.removeSchemesFromProject(project);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void removeSchemesFromProject(GenericValue project) throws GenericEntityException {
        try {
            super.removeSchemesFromProject(project);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void addDefaultSchemeToProject(GenericValue project) throws GenericEntityException {
        try {
            super.addDefaultSchemeToProject(project);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void addDefaultSchemeToProject(Project project) throws DataAccessException {
        try {
            super.addDefaultSchemeToProject(project);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void addSchemeToProject(GenericValue project, GenericValue scheme) throws GenericEntityException {
        try {
            super.addSchemeToProject(project, scheme);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public void addSchemeToProject(Project project, Scheme scheme) throws DataAccessException {
        try {
            super.addSchemeToProject(project, scheme);
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Override
    public Scheme createSchemeAndEntities(Scheme scheme) throws DataAccessException {
        try {
            Scheme scheme2 = super.createSchemeAndEntities(scheme);
            return scheme2;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        try {
            boolean bl = super.removeEntities(type, parameter);
            return bl;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GenericValue createSchemeNoEvent(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createSchemeNoEvent(name, description);
            return genericValue;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scheme createSchemeObject(String name, String description) {
        try {
            Scheme scheme = super.createSchemeObject(name, description);
            return scheme;
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    private WorkflowSchemeEntitiesCache loadAllWorkflowSchemeEntities() {
        QNodeAssociation filteredNodeAssociation = new QNodeAssociation("NodeAssociationFiltered");
        return new WorkflowSchemeEntitiesCache(this.queryDslAccessor.executeQuery(callback -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().select(new Expression[]{filteredNodeAssociation.sourceNodeId, QWorkflowScheme.WORKFLOW_SCHEME.id, QWorkflowSchemeEntity.WORKFLOW_SCHEME_ENTITY}).from((Expression)QWorkflowScheme.WORKFLOW_SCHEME)).leftJoin((EntityPath)QWorkflowSchemeEntity.WORKFLOW_SCHEME_ENTITY)).on((Predicate)QWorkflowScheme.WORKFLOW_SCHEME.id.eq(QWorkflowSchemeEntity.WORKFLOW_SCHEME_ENTITY.scheme))).leftJoin((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)QNodeAssociation.NODE_ASSOCIATION).from((Expression)QNodeAssociation.NODE_ASSOCIATION)).where((Predicate)QNodeAssociation.NODE_ASSOCIATION.sourceNodeEntity.eq((Object)"Project").and((Predicate)QNodeAssociation.NODE_ASSOCIATION.sinkNodeEntity.eq((Object)SCHEME_ENTITY_NAME))), ExpressionUtils.path((Class)QNodeAssociation.NODE_ASSOCIATION.getType(), (String)"NodeAssociationFiltered"))).on((Predicate)QWorkflowScheme.WORKFLOW_SCHEME.id.eq(filteredNodeAssociation.sinkNodeId))).fetch()), this.projectManager.getProjects());
    }

    private static class WorkflowSchemeEntitiesCache {
        private final Map<Long, Long> projectIdToSchemeId;
        private final Map<Long, Map<String, WorkflowSchemeEntityDTO>> workflowSchemeEntities;
        private final Set<String> activeWorkflows;
        private final boolean defaultWorkflowActive;

        public WorkflowSchemeEntitiesCache(List<Tuple> content, List<Project> projects) {
            HashMap projectIdToSchemeId = Maps.newHashMap();
            HashMap workflowSchemeEntities = Maps.newHashMap();
            HashSet activeWorkflows = Sets.newHashSet();
            boolean defaultWorkflowActive = false;
            for (Tuple tuple : content) {
                Long projectId = (Long)tuple.get(0, Long.class);
                Long workflowId = (Long)tuple.get(1, Long.class);
                WorkflowSchemeEntityDTO dto = (WorkflowSchemeEntityDTO)tuple.get(2, WorkflowSchemeEntityDTO.class);
                if (projectId != null) {
                    projectIdToSchemeId.put(projectId, workflowId);
                }
                workflowSchemeEntities.putIfAbsent(workflowId, Maps.newHashMap());
                if (dto == null || dto.getId() == null) continue;
                ((Map)workflowSchemeEntities.get(workflowId)).put(dto.getIssuetype(), dto);
                if (projectId == null) continue;
                activeWorkflows.add(dto.getWorkflow());
            }
            for (Project project : projects) {
                if (projectIdToSchemeId.containsKey(project.getId())) continue;
                activeWorkflows.add("jira");
                defaultWorkflowActive = true;
                break;
            }
            this.projectIdToSchemeId = Collections.unmodifiableMap(projectIdToSchemeId);
            this.workflowSchemeEntities = Collections.unmodifiableMap(workflowSchemeEntities);
            this.activeWorkflows = Collections.unmodifiableSet(activeWorkflows);
            this.defaultWorkflowActive = defaultWorkflowActive;
        }

        public Long getWorkflowIdForProject(Long projectId) {
            return this.projectIdToSchemeId.get(projectId);
        }

        public Map<String, WorkflowSchemeEntityDTO> getByWorkflowId(Long schemeId) {
            return this.workflowSchemeEntities.getOrDefault(schemeId, Collections.emptyMap());
        }

        public Set<String> getActiveWorkflows() {
            return this.activeWorkflows;
        }

        public List<WorkflowSchemeEntityDTO> getAllEntities() {
            return this.workflowSchemeEntities.values().stream().flatMap(entry -> entry.values().stream()).collect(Collectors.toList());
        }

        public boolean isWorkflowActive(Long workflowId) {
            return this.projectIdToSchemeId.containsValue(workflowId);
        }

        public boolean isDefaultWorkflowActive() {
            return this.defaultWorkflowActive;
        }
    }

    static enum WorkflowAction {
        DELETE_ENTITY,
        DELETE_SCHEME,
        DELETE_WORKFLOW_SCHEME,
        UPDATE_DRAFT_WORKFLOW_SCHEME,
        UPDATE_SCHEME,
        UPDATE_WORKFLOW_SCHEME;


        private String getLockName(Long id) {
            return WorkflowAction.class.getName() + "." + (Object)((Object)this) + "_" + id;
        }
    }
}

