/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.condition;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProjectRoleCondition
extends AbstractJiraCondition {
    public static final String KEY_PROJECT_ROLE_ID = "jira.projectrole.id";
    private static final Logger log = LoggerFactory.getLogger(InProjectRoleCondition.class);
    private static final boolean CONDITION_RESULT_ON_MISSING_PROJECT_ROLE = false;

    public boolean passesCondition(Map transientVars, Map args, PropertySet propertySet) throws WorkflowException {
        String rawprojectRoleId = (String)args.get(KEY_PROJECT_ROLE_ID);
        Long projectRoleId = null;
        if (StringUtils.isBlank((CharSequence)rawprojectRoleId)) {
            log.warn("InProjectRoleCondition not configured with a valid projectroleid");
            return false;
        }
        try {
            projectRoleId = new Long(Long.parseLong(rawprojectRoleId));
        }
        catch (NumberFormatException e) {
            log.warn("InProjectRoleCondition not configured with a valid projectroleid, the project role id: " + projectRoleId + " can not be parsed");
            return false;
        }
        ApplicationUser user = this.getCallerUser(transientVars, args);
        Issue issue = this.getIssue(transientVars);
        Project project = issue.getProjectObject();
        ProjectRoleManager projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class);
        ProjectRole projectRole = projectRoleManager.getProjectRole(projectRoleId);
        if (projectRole == null) {
            log.warn("Workflow condition is configured to check user membership in project role that doesn't exist: id is " + projectRoleId + " (workflow condition will fail for everyone!)");
            return false;
        }
        return projectRoleManager.isUserInProjectRole(user, projectRole, project);
    }
}

