/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.edit.TransitionOptions;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.jira.workflow.edit.utilities.OutcomeHelper;
import com.atlassian.jira.workflow.edit.utilities.ScreenNameResolver;
import com.atlassian.jira.workflow.edit.utilities.WorkflowFunctionUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WorkflowsImpl
implements Workflows {
    private static final Logger LOG = Logger.getLogger(WorkflowsImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowFunctionUtilities workflowFunctionUtilities;
    private final WorkflowManager workflowManager;
    private final WorkflowService workflowService;
    private final TransitionOptions transitionOptions;
    private final ScreenNameResolver screenNameResolver;
    private final OutcomeHelper outcomeHelper;

    public WorkflowsImpl(JiraAuthenticationContext jiraAuthenticationContext, WorkflowFunctionUtilities workflowFunctionUtilities, WorkflowManager workflowManager, WorkflowService workflowService, TransitionOptions transitionOptions, ScreenNameResolver screenNameResolver, OutcomeHelper outcomeHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowFunctionUtilities = workflowFunctionUtilities;
        this.workflowManager = workflowManager;
        this.workflowService = workflowService;
        this.transitionOptions = transitionOptions;
        this.screenNameResolver = screenNameResolver;
        this.outcomeHelper = outcomeHelper;
    }

    @Override
    public ServiceOutcome<Workflow> getMutableWorkflow(String workflowName) {
        if ("jira".equals(workflowName)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.rest.resource.workflow.not_editable", new Object[0]);
        }
        ApplicationUser user = this.getCurrentUser();
        if (!this.workflowService.isWorkflowEditable(user, this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(user), workflowName))) {
            return this.outcomeHelper.errorOutcome(user != null ? "workflow.edit.forbidden" : "workflow.edit.workflow.doesnt.exist.not.authenticated", new Object[0]);
        }
        Workflow workflow = this.getOrCreateMutableWorkflow(this.createServiceContext(), workflowName);
        if (workflow == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.workflow.doesnt.exist", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(workflow);
    }

    @Override
    public Workflow getMutableWorkflowWithoutValidation(String workflowName) {
        return this.getOrCreateMutableWorkflow(this.createServiceContext(), workflowName);
    }

    @Override
    public ServiceOutcome<Workflow> saveWorkflow(Workflow workflow) {
        return this.saveWorkflow(workflow, workflow);
    }

    @Override
    public ServiceOutcome<Void> discardDraft(String workflowName) {
        JiraWorkflow workflow = this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName);
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), workflow)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)workflowName)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.rest.resource.workflow.invalid_name", new Object[0]);
        }
        JiraServiceContext serviceContext = this.createServiceContext();
        this.workflowService.deleteDraftWorkflow(serviceContext, workflowName);
        return ServiceOutcomeImpl.ok(null);
    }

    @Override
    public Workflow getWorkflow(boolean isDraft, String workflowName) {
        JiraServiceContext serviceContext = this.createServiceContext();
        JiraWorkflow jiraWorkflow = this.workflowService.getWorkflow(serviceContext, workflowName);
        if (isDraft && jiraWorkflow != null && jiraWorkflow.isActive()) {
            jiraWorkflow = this.getOrCreateDraftWorkflow(serviceContext, workflowName);
        }
        return this.getWorkflow(jiraWorkflow);
    }

    @Override
    public Workflow getDraftWorkflow(String workflowName) {
        JiraServiceContext serviceContext = this.createServiceContext();
        JiraWorkflow jiraWorkflow = this.workflowService.getDraftWorkflow(serviceContext, workflowName);
        return this.getWorkflow(jiraWorkflow);
    }

    @Override
    public Workflow getWorkflow(JiraWorkflow jiraWorkflow) {
        return jiraWorkflow != null ? new Workflow(jiraWorkflow, this.workflowFunctionUtilities, this.jiraAuthenticationContext, this.transitionOptions, this.outcomeHelper, this.screenNameResolver) : null;
    }

    @Override
    public boolean workflowExists(boolean isDraft, String workflowName) {
        return this.getWorkflow(isDraft, workflowName) != null;
    }

    @Override
    public boolean workflowIsEditable(boolean isDraft, String workflowName) {
        Workflow workflow = this.getWorkflow(isDraft, workflowName);
        return workflow != null && workflow.isEditable();
    }

    @Override
    public ServiceOutcome<Workflow> publishDraft(String parentWorkflowName) {
        JiraWorkflow parentWorkflow = this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), parentWorkflowName);
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), parentWorkflow)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        JiraServiceContext serviceContext = this.createServiceContext();
        this.workflowService.overwriteActiveWorkflow(serviceContext, parentWorkflowName);
        ErrorCollection errorCollection = serviceContext.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            return this.outcomeHelper.errorOutcome(errorCollection);
        }
        return ServiceOutcomeImpl.ok(this.getWorkflow(false, parentWorkflowName));
    }

    @Override
    public Workflow getClone(String workflowName) {
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflowClone(workflowName);
        return this.getWorkflow(jiraWorkflow);
    }

    private Workflow getOrCreateMutableWorkflow(JiraServiceContext serviceContext, String workflowName) {
        JiraWorkflow jiraWorkflow;
        JiraWorkflow workflow = this.workflowService.getWorkflow(serviceContext, workflowName);
        if (workflow == null) {
            return null;
        }
        if (workflow.isActive()) {
            jiraWorkflow = this.getOrCreateDraftWorkflow(serviceContext, workflowName);
            if (jiraWorkflow == null) {
                jiraWorkflow = workflow;
            }
        } else {
            jiraWorkflow = this.workflowManager.getWorkflowClone(workflowName);
        }
        return this.getWorkflow(jiraWorkflow);
    }

    private <T> ServiceOutcome<T> saveWorkflow(T value, JiraWorkflow workflow) {
        ErrorCollection saveWorkflowErrors;
        try {
            JiraServiceContext serviceContext = this.createServiceContext();
            this.workflowService.updateWorkflow(serviceContext, workflow);
            saveWorkflowErrors = serviceContext.getErrorCollection();
        }
        catch (Exception e) {
            LOG.error((Object)"saveWorkflow - exception occurred saving workflow", (Throwable)e);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.getText("workflow.edit.saving.workflow.failed", new Object[0]));
            saveWorkflowErrors = errorCollection;
        }
        if (saveWorkflowErrors.hasAnyErrors()) {
            return this.outcomeHelper.errorOutcome(saveWorkflowErrors);
        }
        return ServiceOutcomeImpl.ok(value);
    }

    private JiraWorkflow getOrCreateDraftWorkflow(JiraServiceContext serviceContext, String workflowName) {
        JiraWorkflow workflow = this.workflowService.getDraftWorkflow(serviceContext, workflowName);
        if (workflow == null) {
            workflow = this.workflowService.createDraftWorkflow(serviceContext, workflowName);
        }
        return workflow;
    }

    private JiraServiceContext createServiceContext() {
        return new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser());
    }

    private ApplicationUser getCurrentUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    private String getText(String messageKey, Object ... arguments) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(messageKey, (Object)arguments);
    }
}

