/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.names;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowsRepository;
import com.atlassian.jira.workflow.names.WorkflowCopyNameFactory;
import com.google.common.base.Function;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;

@Internal
@InjectableComponent
@Immutable
public class DefaultWorkflowCopyNameFactory
implements WorkflowCopyNameFactory {
    private final WorkflowsRepository workflowsRepository;
    private final PrefixCopyOf prefixCopyOf;

    public DefaultWorkflowCopyNameFactory(WorkflowsRepository workflowsRepository, I18nHelper.BeanFactory i18n) {
        this.workflowsRepository = workflowsRepository;
        this.prefixCopyOf = new PrefixCopyOf(i18n);
    }

    public String createFrom(String sourceWorkflowName, @Nonnull Locale locale) {
        Assertions.notNull((String)"Can not generate a name for a workflow copy for a 'null' Locale", (Object)locale);
        int i = 1;
        do {
            String candidateNameForCopy;
            if (this.workflowsRepository.contains(candidateNameForCopy = this.shorten(this.prefixCopyOfOn(locale, sourceWorkflowName, i)))) continue;
            return candidateNameForCopy;
        } while (++i != Integer.MIN_VALUE);
        throw new WorkflowCopyNameFactory.UnableToGenerateASuitableWorkflowName();
    }

    private String prefixCopyOfOn(Locale locale, String sourceWorkflowName, int i) {
        return this.prefixCopyOf.on(locale, sourceWorkflowName, i);
    }

    private String shorten(String sourceWorkflowName) {
        return ShortenWorkflowNameFunction.INSTANCE.apply(sourceWorkflowName);
    }

    private static enum ShortenWorkflowNameFunction implements Function<String, String>
    {
        INSTANCE;


        public String apply(String source) {
            return StringUtils.abbreviate((String)source, (int)255);
        }
    }

    private static class PrefixCopyOf {
        private final I18nHelper.BeanFactory i18n;

        public PrefixCopyOf(I18nHelper.BeanFactory i18n) {
            this.i18n = i18n;
        }

        public String on(Locale locale, String source, Integer number) {
            return this.i18n.getInstance(locale).getText("admin.workflows.copy.name", (Object)new Object[]{number, StringUtils.trimToEmpty((String)source)});
        }
    }
}

