/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.auth;

import com.atlassian.mail.auth.JiraMailOAuth2Credentials;
import com.atlassian.mail.auth.JiraMailUserPasswordCredentials;
import com.atlassian.mail.auth.JiraOauth2AuthenticationContext;
import com.atlassian.mail.server.DefaultAuthContextFactory;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.AuthenticationContextFactory;
import com.atlassian.mail.server.auth.Credentials;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class JiraAuthenticationContextFactory
implements AuthenticationContextFactory {
    private static final Map<Predicate<Credentials>, Function<Credentials, AuthenticationContext>> SUPPORTED_AUTHENTICATIONS = ImmutableMap.of(credentials -> credentials instanceof JiraMailOAuth2Credentials, credentials -> new JiraOauth2AuthenticationContext((JiraMailOAuth2Credentials)credentials), credentials -> credentials instanceof JiraMailUserPasswordCredentials, credentials -> DefaultAuthContextFactory.getInstance().createAuthenticationContext(credentials));

    @Nullable
    public AuthenticationContext createAuthenticationContext(Credentials credentials) {
        Optional<AuthenticationContext> authCtx = SUPPORTED_AUTHENTICATIONS.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test((Object)credentials)).findFirst().map(entry -> (AuthenticationContext)((Function)entry.getValue()).apply((Object)credentials));
        return authCtx.orElse(null);
    }
}

