/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.auth;

import com.atlassian.mail.auth.DefaultJiraMailOAuth2Credentials;
import com.atlassian.mail.server.auth.OAuthCredentials;
import java.util.Properties;

public interface JiraMailOAuth2Credentials
extends OAuthCredentials {
    public static final String XOAUTH_USE_TWO_LINES_AUTHENTICATION = "mail.pop3s.xoauth.two.line.authentication.format";

    public String getTokenId();

    public String getUserName();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String userName;
        private String accessToken;
        private String refreshToken;
        private String tokenId;
        private Properties properties;

        private Builder() {
        }

        public JiraMailOAuth2Credentials build() {
            return new DefaultJiraMailOAuth2Credentials(this.userName, this.accessToken, this.refreshToken, this.tokenId, this.properties);
        }

        public Builder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder withTokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.properties = properties;
            return this;
        }
    }
}

