/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers.jira;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.mail.auth.JiraMailOAuth2Credentials;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.AuthenticationContextAware;
import com.atlassian.mail.server.auth.Credentials;
import com.atlassian.mail.server.auth.UserPasswordCredentials;
import com.atlassian.mail.server.managers.jira.EncryptionManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;

public class AuthConfigMapper {
    private static final AuthConfigMapper instance = new AuthConfigMapper();
    final EncryptionManager encryptionManager;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    static AuthConfigMapper getInstance() {
        return instance;
    }

    private AuthConfigMapper() {
        this.encryptionManager = new EncryptionManager();
    }

    @VisibleForTesting
    public AuthConfigMapper(EncryptionManager encryptionManager) {
        this.encryptionManager = encryptionManager;
    }

    Map<String, Object> toColumnMap(MailServer server) {
        if (server == null) {
            return Collections.emptyMap();
        }
        ConfigurationData config = this.toConfigurationData(server);
        return this.toColumnMap(config);
    }

    ConfigurationData toConfigurationData(MailServer server) {
        if (server == null) {
            return null;
        }
        if (server instanceof AuthenticationContextAware) {
            AuthenticationContext authCtx = ((AuthenticationContextAware)server).getAuthenticationContext();
            return this.createConfiguration(authCtx.getCredentials());
        }
        return new UserPasswordConfiguration(server.getUsername(), server.getPassword());
    }

    Map<String, Object> toColumnMap(ConfigurationData config) {
        HashMap<String, Object> columns = new HashMap<String, Object>();
        if (config instanceof OAuthConfiguration) {
            columns.put("authconfig", this.toJSON(config));
        }
        if (config instanceof UserPasswordConfiguration) {
            columns.put("username", ((UserPasswordConfiguration)config).getUserName());
            String password = ((UserPasswordConfiguration)config).getPassword();
            Pair<String, String> passwordAndCipherType = this.encryptionManager.encryptPassword(password, "Base64Cipher");
            columns.put("password", passwordAndCipherType.first());
            columns.put("cipherType", passwordAndCipherType.second());
        }
        return columns;
    }

    String toJSON(ConfigurationData config) {
        try {
            return this.jsonMapper.writeValueAsString((Object)config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ConfigurationData fromJSON(String stringValue) {
        try {
            return (ConfigurationData)this.jsonMapper.readValue(stringValue.getBytes(), ConfigurationData.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ConfigurationData toConfigurationData(Map<String, Object> attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            Object jsonAuthConfig = attributes.get("authconfig");
            if (jsonAuthConfig instanceof String && StringUtils.isNotEmpty((CharSequence)((String)jsonAuthConfig))) {
                try {
                    return this.fromJSON((String)jsonAuthConfig);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String password = (String)attributes.get("password");
            String cipherType = (String)attributes.get("cipherType");
            return new UserPasswordConfiguration((String)attributes.get("username"), this.encryptionManager.decryptPassword(password, cipherType));
        }
        return null;
    }

    private ConfigurationData createConfiguration(Credentials credentials) {
        if (credentials instanceof JiraMailOAuth2Credentials) {
            JiraMailOAuth2Credentials oauthCredentials = (JiraMailOAuth2Credentials)credentials;
            return new OAuthConfiguration(oauthCredentials.getUserName(), oauthCredentials.getTokenId(), oauthCredentials.getProperties().orElse(new Properties()));
        }
        if (credentials instanceof UserPasswordCredentials) {
            UserPasswordCredentials basicCredentials = (UserPasswordCredentials)credentials;
            return new UserPasswordConfiguration(basicCredentials.getUserName(), basicCredentials.getPassword());
        }
        throw new IllegalArgumentException("Unknown credentials type.");
    }

    static class OAuthConfiguration
    extends ConfigurationData {
        private String userName;
        private String tokenId;
        private final Map<Object, Object> properties = new HashMap<Object, Object>();

        OAuthConfiguration() {
        }

        OAuthConfiguration(String userName, String tokenId) {
            this();
            this.userName = userName;
            this.tokenId = tokenId;
        }

        OAuthConfiguration(String userName, String tokenId, Map<Object, Object> properties) {
            this();
            this.userName = userName;
            this.tokenId = tokenId;
            this.properties.putAll(properties);
        }

        public String getUserName() {
            return this.userName;
        }

        private OAuthConfiguration setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public String getTokenId() {
            return this.tokenId;
        }

        private OAuthConfiguration setTokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Map<Object, Object> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        private OAuthConfiguration setProperties(Map<Object, Object> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
            return this;
        }
    }

    static class UserPasswordConfiguration
    extends ConfigurationData {
        private String userName;
        private String password;

        UserPasswordConfiguration() {
        }

        UserPasswordConfiguration(String userName, String password) {
            this();
            this.userName = userName;
            this.password = password;
        }

        public String getUserName() {
            return this.userName;
        }

        private UserPasswordConfiguration setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        private UserPasswordConfiguration setPassword(String password) {
            this.password = password;
            return this;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=UserPasswordConfiguration.class, name="UserPasswordConfiguration"), @JsonSubTypes.Type(value=OAuthConfiguration.class, name="OAuthConfiguration")})
    static abstract class ConfigurationData {
        ConfigurationData() {
        }
    }

    static final class MapKeys {
        static final String AUTH_CONFIG = "authconfig";
        static final String USER_NAME = "username";
        static final String PASSWORD = "password";
        static final String CIPHER_TYPE = "cipherType";

        MapKeys() {
        }
    }
}

