/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.ps.ConfigPropertySet;

public final class AttachmentDirectoryChecker
implements ConfigurationCheck {
    public static final String CHECKID_ATTACH_HOME = "attachhome";
    public static final String CHECKID_ATTACH_DIR = "attachdirectory";
    private static final String PROP_ATTACH_ENABLED = "jira.option.allowattachments";
    private static final String PROP_ATTACH_PATH = "jira.path.attachments";
    private static final String PROP_ATTACH_DEFAULT_DIR = "jira.path.attachments.use.default.directory";
    private static final String JIRA_FUNC_ATTACHMENT = "func_test_attachments";

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        try {
            this.processConfig(config, options, builder);
        }
        catch (Exception e) {
            return builder.error(e.getMessage()).buildResult();
        }
        return builder.buildResult();
    }

    private void processConfig(JiraConfig config, CheckOptions options, CheckResultBuilder builder) {
        ConfigPropertySet propertySet = config.getApplicationProperties();
        String directory = propertySet.getStringPropertyDefault(PROP_ATTACH_PATH, "<nothing>");
        if (options.checkEnabled(CHECKID_ATTACH_HOME) && !propertySet.getBooleanPropertyDefault(PROP_ATTACH_DEFAULT_DIR, false).booleanValue()) {
            if (propertySet.getBooleanPropertyDefault(PROP_ATTACH_ENABLED, false).booleanValue()) {
                builder.error("File has '" + directory + "' configured as its attachment path. It should be using its JIRA.HOME.", CHECKID_ATTACH_HOME);
            } else {
                builder.warning("File has '" + directory + "' configured as its attachment path. It should be using its JIRA.HOME.", CHECKID_ATTACH_HOME);
            }
        }
        if (options.checkEnabled(CHECKID_ATTACH_DIR) && propertySet.contains(PROP_ATTACH_PATH) && !JIRA_FUNC_ATTACHMENT.equals(directory)) {
            builder.warning(String.format("File has '%s' configured as it attachment path. It should always be set to '%s' even when using JIRA.HOME.", directory, JIRA_FUNC_ATTACHMENT), CHECKID_ATTACH_DIR);
        }
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        ConfigPropertySet propertySet = config.getApplicationProperties();
        if (options.checkEnabled(CHECKID_ATTACH_HOME)) {
            propertySet.setBooleanProperty(PROP_ATTACH_DEFAULT_DIR, true);
        }
        if (options.checkEnabled(CHECKID_ATTACH_DIR) && propertySet.contains(PROP_ATTACH_PATH)) {
            propertySet.setStringProperty(PROP_ATTACH_PATH, JIRA_FUNC_ATTACHMENT);
        }
    }
}

