/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckMessage;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class CheckResultBuilder {
    private final Set<CheckMessage> errors = new LinkedHashSet<CheckMessage>();
    private final Set<CheckMessage> warnings = new LinkedHashSet<CheckMessage>();

    public CheckResultBuilder error(String message) {
        this.errors.add(new CheckMessage(message, null));
        return this;
    }

    public CheckResultBuilder error(String message, String checkId) {
        this.errors.add(new CheckMessage(message, checkId));
        return this;
    }

    public CheckResultBuilder warning(String message) {
        this.warnings.add(new CheckMessage(message, null));
        return this;
    }

    public CheckResultBuilder warning(String message, String checkId) {
        this.warnings.add(new CheckMessage(message, checkId));
        return this;
    }

    public Result buildResult() {
        return new Result(this.errors, this.warnings);
    }

    private static class Result
    implements ConfigurationCheck.Result {
        private final Collection<CheckMessage> errors;
        private Collection<CheckMessage> warnings;

        private Result(Collection<CheckMessage> errors, Collection<CheckMessage> warnings) {
            this.errors = Collections.unmodifiableList(new ArrayList<CheckMessage>(errors));
            this.warnings = Collections.unmodifiableList(new ArrayList<CheckMessage>(warnings));
        }

        @Override
        public Collection<CheckMessage> getErrors() {
            return this.errors;
        }

        @Override
        public Collection<CheckMessage> getWarnings() {
            return this.warnings;
        }

        @Override
        public boolean isGood() {
            return this.warnings.isEmpty() && this.errors.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            if (!this.errors.equals(result.errors)) {
                return false;
            }
            return this.warnings.equals(result.warnings);
        }

        public int hashCode() {
            int result = this.errors.hashCode();
            result = 31 * result + this.warnings.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Errors: %s, Warnings: %s.", this.errors, this.warnings);
        }
    }
}

