/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.crowd;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextEncoderChecker
implements ConfigurationCheck {
    private static final Logger log = LoggerFactory.getLogger(PlaintextEncoderChecker.class);
    public static final String CHECK_PLAINTEXT_ENCODER = "plaintextencoder";

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        if (options.checkEnabled(CHECK_PLAINTEXT_ENCODER)) {
            List<Element> encryptionMethods = ConfigXmlUtils.getElementsByXpath(config.getDocument(), "/entity-engine-xml/DirectoryAttribute[@name='user_encryption_method']");
            Iterator<Element> iterator = encryptionMethods.iterator();
            while (iterator.hasNext()) {
                String fastEncryptionMethodValue = "plaintext";
                Element encryptionMethod = iterator.next();
                String currentEncryptionMethodValue = ConfigXmlUtils.getTextValue(encryptionMethod, "value");
                if (fastEncryptionMethodValue.equals(currentEncryptionMethodValue)) continue;
                builder.error(String.format("DirectoryAttribute 'user_encryption_method' is not set to '%s'. You can run the ConfigFixerUpperer to fix this and also to reset users passwords to be their username in plaintext", fastEncryptionMethodValue), CHECK_PLAINTEXT_ENCODER);
            }
        }
        return builder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        List<Element> encryptionMethods = ConfigXmlUtils.getElementsByXpath(config.getDocument(), "/entity-engine-xml/DirectoryAttribute[@name='user_encryption_method']");
        Iterator<Element> iterator = encryptionMethods.iterator();
        while (iterator.hasNext()) {
            String fastEncryptionMethodValue = "plaintext";
            Element encryptionMethod = iterator.next();
            String currentEncryptionMethodValue = ConfigXmlUtils.getTextValue(encryptionMethod, "value");
            if (fastEncryptionMethodValue.equals(currentEncryptionMethodValue)) continue;
            log.info(String.format("Changing 'user_encryption_method' from '%s' to '%s'", currentEncryptionMethodValue, fastEncryptionMethodValue));
            ConfigXmlUtils.setAttribute(encryptionMethod, "value", (Object)fastEncryptionMethodValue);
            List<Element> users = ConfigXmlUtils.getElementsByXpath(config.getDocument(), "/entity-engine-xml/User");
            for (Element user : users) {
                String username = ConfigXmlUtils.getTextValue(user, "userName");
                log.info(String.format("Setting credential (password) of user '%s' to '%s'", username, username));
                ConfigXmlUtils.setAttribute(user, "credential", (Object)username);
            }
            config.markDirty();
        }
    }
}

