/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.dashboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;

public abstract class ConfigGadgetSupport<T> {
    private final Document document;

    protected ConfigGadgetSupport(Document document) {
        this.document = document;
    }

    public boolean sync(Collection<? extends T> gadgets) {
        List<T> oldGadgets = this.loadAll();
        HashMap<Long, T> gadgetMap = new HashMap<Long, T>();
        for (T oldGadget : oldGadgets) {
            gadgetMap.put(this.getId(oldGadget), oldGadget);
        }
        boolean returnValue = false;
        for (Object gadget : gadgets) {
            Object oldGadget = gadgetMap.get(this.getId(gadget));
            if (oldGadget == null) {
                returnValue = this.create(gadget) | returnValue;
                continue;
            }
            returnValue = this.update(oldGadget, gadget) | returnValue;
            gadgetMap.remove(this.getId(gadget));
        }
        for (Object gadget : gadgetMap.values()) {
            returnValue = this.delete(gadget) | returnValue;
        }
        return returnValue;
    }

    Document getDocument() {
        return this.document;
    }

    public abstract List<T> loadAll();

    public abstract boolean create(T var1);

    public abstract boolean update(T var1, T var2);

    public abstract boolean delete(T var1);

    public abstract Long getId(T var1);
}

