/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.sharing;

import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.sharing.ConfigSharedEntity;
import com.atlassian.jira.functest.config.sharing.ConfigSharedEntityCleaner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dom4j.Document;
import org.dom4j.Element;

public class FavouritesCleaner
implements ConfigSharedEntityCleaner {
    private final Document document;

    public FavouritesCleaner(Document document) {
        this.document = document;
    }

    @Override
    public boolean clean(ConfigSharedEntity entity) {
        List<FavouriteAssociation> favourites = this.getFavouritesForEntity(entity);
        if (favourites.isEmpty()) {
            return false;
        }
        for (FavouriteAssociation favourite : favourites) {
            favourite.delete();
            List<FavouriteAssociation> userFavourites = this.getUserFavourites(favourite);
            Collections.sort(userFavourites);
            int count = 0;
            for (FavouriteAssociation userFavourite : userFavourites) {
                userFavourite.setSequence(count++);
                userFavourite.save();
            }
        }
        return true;
    }

    private List<FavouriteAssociation> getFavouritesForEntity(ConfigSharedEntity entity) {
        if (entity.getId() == null || StringUtils.isBlank((CharSequence)entity.getEntityType())) {
            return Collections.emptyList();
        }
        return this.getFavouritesFromXpath(String.format("/entity-engine-xml/FavouriteAssociations[@entityId='%d' and @entityType='%s']", entity.getId(), entity.getEntityType()));
    }

    private List<FavouriteAssociation> getUserFavourites(FavouriteAssociation association) {
        if (StringUtils.isBlank((CharSequence)association.getOwner()) || StringUtils.isBlank((CharSequence)association.getEntityType())) {
            return Collections.emptyList();
        }
        return this.getFavouritesFromXpath(String.format("/entity-engine-xml/FavouriteAssociations[@username='%s' and @entityType='%s']", association.getOwner(), association.getEntityType()));
    }

    private List<FavouriteAssociation> getFavouritesFromXpath(String xpath) {
        List<Element> list = ConfigXmlUtils.getElementsByXpath(this.document, xpath);
        ArrayList<FavouriteAssociation> associations = new ArrayList<FavouriteAssociation>(list.size());
        for (Element element : list) {
            associations.add(new FavouriteAssociation(element));
        }
        return associations;
    }

    private static class FavouriteAssociation
    implements Comparable<FavouriteAssociation> {
        private static final String ATTRIBUTE_ID = "id";
        private static final String ATTRIBUTE_USERNAME = "username";
        private static final String ATTRIBUTE_ENTITY_TYPE = "entityType";
        private static final String ATTRIBUTE_ENTITY_ID = "entityId";
        private static final String ATTRIBUTE_SEQUENCE = "sequence";
        private Long id;
        private String owner;
        private String entityType;
        private Long entityId;
        private Integer sequence;
        private Element element;

        FavouriteAssociation(Element element) {
            this.id = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_ID);
            this.owner = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_USERNAME);
            this.entityType = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_ENTITY_TYPE);
            this.entityId = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_ENTITY_ID);
            this.sequence = ConfigXmlUtils.getIntegerValue(element, ATTRIBUTE_SEQUENCE);
            this.element = element;
        }

        void delete() {
            ConfigXmlUtils.removeElement(this.element);
        }

        void save() {
            ConfigXmlUtils.setAttribute(this.element, ATTRIBUTE_ID, this.id);
            ConfigXmlUtils.setAttribute(this.element, ATTRIBUTE_USERNAME, (Object)this.owner);
            ConfigXmlUtils.setAttribute(this.element, ATTRIBUTE_ENTITY_TYPE, (Object)this.entityType);
            ConfigXmlUtils.setAttribute(this.element, ATTRIBUTE_ENTITY_ID, this.entityId);
            ConfigXmlUtils.setAttribute(this.element, ATTRIBUTE_SEQUENCE, this.sequence);
        }

        Element getElement() {
            return this.element;
        }

        Long getEntityId() {
            return this.entityId;
        }

        FavouriteAssociation setEntityId(Long entityId) {
            this.entityId = entityId;
            return this;
        }

        Long getId() {
            return this.id;
        }

        FavouriteAssociation setId(Long id) {
            this.id = id;
            return this;
        }

        String getOwner() {
            return this.owner;
        }

        FavouriteAssociation setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        String getEntityType() {
            return this.entityType;
        }

        FavouriteAssociation setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        Integer getSequence() {
            return this.sequence;
        }

        FavouriteAssociation setSequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        @Override
        public int compareTo(FavouriteAssociation o) {
            if (this.sequence == null) {
                if (o.sequence == null) {
                    return 0;
                }
                return 1;
            }
            if (o.sequence == null) {
                return -1;
            }
            return this.sequence.compareTo(o.sequence);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FavouriteAssociation that = (FavouriteAssociation)o;
            if (this.entityType != null ? !this.entityType.equals(that.entityType) : that.entityType != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
                return false;
            }
            return !(this.sequence != null ? !this.sequence.equals(that.sequence) : that.sequence != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.entityType != null ? this.entityType.hashCode() : 0);
            result = 31 * result + (this.sequence != null ? this.sequence.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

