/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HeaderOnlyWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class FuncTestRestClient {
    private final WebTester tester;
    private final FuncTestUrlHelper funcTestUrlHelper;

    @Inject
    public FuncTestRestClient(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.funcTestUrlHelper = new FuncTestUrlHelper(environmentData);
    }

    public JSONObject getJSON(String url, String ... expand) throws JSONException {
        String queryString = expand != null && expand.length > 0 ? "?expand=" + StringUtils.join((Object[])expand, (char)',') : "";
        this.tester.gotoPage(url + queryString);
        return new JSONObject(this.tester.getDialog().getResponseText());
    }

    public WebResponse GET(String url) throws IOException, SAXException {
        return this.GET(url, Collections.emptyMap());
    }

    public WebResponse GET(String url, Map<String, String> headers) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        for (Map.Entry<String, String> headerField : headers.entrySet()) {
            this.tester.getDialog().getWebClient().setHeaderField(headerField.getKey(), headerField.getValue());
        }
        GetMethodWebRequest request = new GetMethodWebRequest(this.funcTestUrlHelper.getBaseUrlPlus(url));
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse DELETE(String url) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HeaderOnlyWebRequest delete = new HeaderOnlyWebRequest(this.funcTestUrlHelper.getBaseUrlPlus(url)){

            public String getMethod() {
                return "DELETE";
            }

            protected void completeRequest(URLConnection connection) throws IOException {
                ((HttpURLConnection)connection).setRequestMethod(this.getMethod());
                super.completeRequest(connection);
            }
        };
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)delete);
    }

    public WebResponse POST(String url, JSONObject json) throws IOException, SAXException {
        return this.POST(url, json.toString());
    }

    public WebResponse POST(String url, String postBody) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PostMethodWebRequest request = new PostMethodWebRequest(this.funcTestUrlHelper.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse PUT(String url, JSONObject json) throws IOException, SAXException {
        return this.PUT(url, json.toString());
    }

    public WebResponse PUT(String url, String postBody) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PutMethodWebRequest request = new PutMethodWebRequest(this.funcTestUrlHelper.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }
}

