/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.functest.rule.BeforeBuildRule;
import com.atlassian.jira.functest.rule.CheckCachesRule;
import com.atlassian.jira.functest.rule.DevModeRule;
import com.atlassian.jira.functest.rule.DisableOnboardingRule;
import com.atlassian.jira.functest.rule.EnableAnalyticsRule;
import com.atlassian.jira.functest.rule.EnsureJiraSetupRule;
import com.atlassian.jira.functest.rule.HttpUnitConfigurationRule;
import com.atlassian.jira.functest.rule.InjectFieldsRule;
import com.atlassian.jira.functest.rule.LogTimeRule;
import com.atlassian.jira.functest.rule.LoginAsRule;
import com.atlassian.jira.functest.rule.OutgoingMailTestRule;
import com.atlassian.jira.functest.rule.RerunIfFailedGlobalRule;
import com.atlassian.jira.functest.rule.RestoreDataRule;
import com.atlassian.jira.functest.rule.SetBaseUrlRule;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.functest.rule.TpmDbRule;
import com.atlassian.jira.functest.rule.WebTesterRule;
import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.function.Supplier;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class FuncTestRuleChain {
    public static RuleChain forTest(Object test) {
        FuncTestWebClientListener webClientListener = new FuncTestWebClientListener();
        BackdoorModule backdoorModule = new BackdoorModule();
        Supplier<FuncTestWebClientListener> clientListenerSupplier = () -> webClientListener;
        Supplier<JIRAEnvironmentData> environmentDataSupplier = backdoorModule::getEnvironmentData;
        WebTesterRule webTesterRule = new WebTesterRule(environmentDataSupplier, clientListenerSupplier);
        Injector injector = Guice.createInjector((Module[])new Module[]{webTesterRule, backdoorModule, binder -> binder.bind(FuncTestLogger.class).toProvider(() -> new FuncTestLoggerImpl(3)), binder -> binder.bind(XmlBackupCopier.class).toProvider(() -> new XmlBackupCopier(backdoorModule.getEnvironmentData().getBaseUrl()))});
        Supplier<Backdoor> testkitSupplier = () -> ((Provider)injector.getProvider(Backdoor.class)).get();
        Supplier<Navigation> navigationSupplier = () -> ((Provider)injector.getProvider(Navigation.class)).get();
        Supplier<EnvironmentUtils> environmentUtilsSupplier = () -> ((Provider)injector.getProvider(EnvironmentUtils.class)).get();
        return RuleChain.emptyRuleChain().around((TestRule)new RerunIfFailedGlobalRule()).around((TestRule)new LogTimeRule(environmentDataSupplier, clientListenerSupplier, testkitSupplier)).around((TestRule)new SinceBuildRule(backdoorModule)).around((TestRule)new BeforeBuildRule(backdoorModule)).around((TestRule)new RestoreDataRule(backdoorModule)).around((TestRule)new DisableOnboardingRule(backdoorModule)).around((TestRule)new EnsureJiraSetupRule(backdoorModule, environmentDataSupplier, () -> {
            HttpUnitConfigurationRule.restoreDefaults();
            return new WebTesterRule(environmentDataSupplier, clientListenerSupplier).get();
        })).around((TestRule)new SetBaseUrlRule(backdoorModule)).around((TestRule)new HttpUnitConfigurationRule()).around((TestRule)webTesterRule).around((TestRule)new OutgoingMailTestRule(backdoorModule)).around((TestRule)new LoginAsRule(navigationSupplier)).around((TestRule)new TpmDbRule(environmentUtilsSupplier)).around((TestRule)new EnableAnalyticsRule(backdoorModule)).around((TestRule)new DevModeRule(backdoorModule)).around((TestRule)new CheckCachesRule(backdoorModule)).around((TestRule)new InjectFieldsRule(injector, test));
    }
}

