/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Footer;
import com.atlassian.jira.functest.framework.FooterImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.framework.util.dom.SneakyDomExtractor;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.webtests.table.HtmlTable;
import com.meterware.httpunit.WebLink;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HtmlPage {
    private final WebTester tester;

    @Inject
    public HtmlPage(WebTester tester) {
        this.tester = tester;
    }

    public HtmlTable getHtmlTable(String tableID) {
        return HtmlTable.newHtmlTable(this.tester, tableID);
    }

    public boolean isLinkPresentWithExactText(String text) {
        WebLink[] webLinks = this.getLinksWithExactText(text);
        return webLinks.length > 0;
    }

    public WebLink[] getLinksWithExactText(String text) {
        try {
            return this.tester.getDialog().getResponse().getMatchingLinks(WebLink.MATCH_TEXT, (Object)text);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String getXsrfToken() {
        XPathLocator locator = new XPathLocator(this.tester, "//meta[@id='atlassian-token']");
        Element meta = (Element)locator.getNode();
        if (meta != null) {
            return URLUtil.encode(meta.getAttribute("content"));
        }
        return "";
    }

    public String getFreshXsrfToken() {
        this.tester.beginAt("/secure/Dashboard.jspa");
        return this.getXsrfToken();
    }

    public String addXsrfToken(String url) {
        return URLUtil.addXsrfToken(this.getXsrfToken(), url);
    }

    public Footer getFooter() {
        return new FooterImpl(this.tester.getDialog().getResponse());
    }

    public String asString() {
        return this.tester.getDialog().getResponseText();
    }

    public String getCollapsedResponseText() {
        Document doc = SneakyDomExtractor.getDOM(this.tester);
        Element bodyE = DomKit.getBodyElement(doc);
        String text = bodyE != null ? DomKit.getCollapsedText(bodyE) : "";
        return text;
    }

    public Optional<String> getRegexMatch(String regex) {
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(this.asString());
        boolean matches = matcher.find();
        if (matches) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }
}

