/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.Screens;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class ScreensImpl
implements Screens {
    private final Navigation navigation;
    private final WebTester tester;
    private final TextAssertions textAssertions;
    private final FuncTestLogger logger;

    @Inject
    public ScreensImpl(JIRAEnvironmentData environmentData, Navigation navigation, WebTester tester, TextAssertions textAssertions) {
        this.navigation = navigation;
        this.tester = tester;
        this.textAssertions = textAssertions;
        this.logger = new FuncTestLoggerImpl(2);
    }

    @Override
    public void addScreen(String screenName, String screenDescription) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
        this.tester.clickLink("add-field-screen");
        this.tester.setWorkingForm("field-screen-add");
        this.tester.setFormElement("fieldScreenName", screenName);
        this.tester.setFormElement("fieldScreenDescription", screenDescription);
        this.tester.submit("Add");
    }

    @Override
    public void deleteScreen(String screenName) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
        this.tester.clickLink("delete_fieldscreen_" + screenName);
        this.tester.submit("Delete");
    }

    @Override
    public void addFieldScreenScheme(String schemeName, String schemeDescription) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("add-field-screen-scheme");
        this.tester.setWorkingForm("field-screen-scheme-add");
        this.tester.setFormElement("fieldScreenSchemeName", schemeName);
        this.tester.setFormElement("fieldScreenSchemeDescription", schemeDescription);
        this.tester.submit("Add");
    }

    @Override
    public void copyFieldScreenScheme(String copiedSchemeName, String schemeName, String schemeDescription) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("copy_fieldscreenscheme_" + copiedSchemeName);
        this.tester.setFormElement("fieldScreenSchemeName", schemeName);
        this.tester.setFormElement("fieldScreenSchemeDescription", schemeDescription);
        this.tester.submit("Copy");
    }

    @Override
    public void deleteFieldScreenScheme(String schemeName) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREEN_SCHEME.getUrl());
        try {
            this.tester.assertLinkPresent("configure_fieldscreenscheme_" + schemeName);
        }
        catch (AssertionError e) {
            this.logger.log((Object)"Scheme does not exist");
        }
        this.tester.clickLink("delete_fieldscreenscheme_" + schemeName);
        this.tester.submit("Delete");
    }

    @Override
    public void removeAllRemainingScreenAssociationsFromDefault() {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("configure_fieldscreenscheme_Default Screen Scheme");
        if (this.tester.getDialog().isLinkPresentWithText("Delete")) {
            this.tester.clickLinkWithText("Delete");
            this.removeAllRemainingScreenAssociationsFromDefault();
        }
    }

    @Override
    public void removeAllRemainingFieldScreens() {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
        if (this.tester.getDialog().isLinkPresentWithText("Delete")) {
            this.tester.clickLinkWithText("Delete");
            this.tester.submit("Delete");
            this.removeAllRemainingFieldScreens();
        }
    }

    @Override
    public void addIssueTypeFieldScreenScheme(String schemeName, String schemeDescription, String defaultScreenScheme) {
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("add-issue-type-screen-scheme");
        this.tester.setFormElement("schemeName", schemeName);
        this.tester.setFormElement("schemeDescription", schemeDescription);
        this.tester.selectOption("fieldScreenSchemeId", defaultScreenScheme);
        this.tester.submit("Add");
    }

    @Override
    public void deleteIssueTypeFieldScreenScheme(String schemeId) {
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("delete_issuetypescreenscheme_" + schemeId);
        this.tester.submit("Delete");
    }

    @Override
    public void copyIssueTypeFieldScreenSchemeName(String copiedSchemeId, String schemeName, String schemeDescription) {
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("copy_issuetypescreenscheme_" + copiedSchemeId);
        this.tester.setFormElement("schemeName", schemeName);
        this.tester.setFormElement("schemeDescription", schemeDescription);
        this.tester.submit("Copy");
    }

    @Override
    public void addIssueOperationToScreenAssociation(String schemeName, String issueOperation, String screenName) {
        this.logger.log((Object)("Adding screen " + screenName + " to operation '" + issueOperation + "'."));
        this.gotoFieldScreenScheme(schemeName);
        this.tester.clickLink("add-screen-scheme-item");
        this.tester.selectOption("issueOperationId", issueOperation);
        this.tester.selectOption("fieldScreenId", screenName);
        this.tester.submit("Add");
    }

    @Override
    public void deleteIssueOperationFromScreenAssociation(String schemeName, String issueOperation) {
        this.logger.log((Object)("Deleting operation '" + issueOperation + "' from scheme " + schemeName + "."));
        this.gotoFieldScreenScheme(schemeName);
        try {
            this.tester.clickLink("delete_fieldscreenscheme_" + issueOperation);
        }
        catch (AssertionError e) {
            this.logger.log((Object)"Issue Operation not configured");
        }
    }

    @Override
    public void deleteTabFromScreen(String screenName, String tabName) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.tester.clickLinkWithText("Delete");
        this.tester.submit("Delete");
    }

    private String findRowWithName(String fieldTableName, int column, String fieldName) {
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID(fieldTableName);
            return fieldTable == null ? null : (String)IntStream.range(1, fieldTable.getRowCount()).boxed().collect(Collectors.toMap(Function.identity(), i -> fieldTable.getCellAsText(i.intValue(), column), (x, y) -> x, TreeMap::new)).entrySet().stream().filter(entry -> ((String)entry.getValue()).contains(fieldName)).map(Map.Entry::getKey).map(i -> i - 1).map(Object::toString).findFirst().orElse(null);
        }
        catch (SAXException ignored) {
            Fail.fail((String)"Cannot find table with id 'field_table'.");
            return null;
        }
    }

    @Override
    public void removeFieldFromFieldScreenTab(String screenName, String tabName, String[] fieldNames) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.tester.assertTextPresent("Configure Screen");
        for (String fieldName : fieldNames) {
            String indexName = this.findRowWithName("field_table", 1, fieldName);
            if (indexName != null) {
                int index = Integer.parseInt(indexName);
                this.tester.checkCheckbox("removeField_" + index);
                this.tester.assertCheckboxSelected("removeField_" + index);
                continue;
            }
            this.logger.log((Object)("Field " + fieldName + " not present"));
        }
        this.tester.submit("deleteFieldsFromTab");
    }

    private void gotoFieldScreenScheme(String schemeName) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("configure_fieldscreenscheme_" + schemeName);
    }

    private void gotoFieldScreenTab(String screenName, String tabName) {
        this.gotoFieldScreen(screenName);
        try {
            this.tester.assertTextPresent("Add one or more fields to the");
            this.textAssertions.assertTextSequence("<b>" + tabName + "</b>", "tab.", new String[0]);
        }
        catch (AssertionError e) {
            this.tester.clickLinkWithText(tabName);
        }
    }

    private void gotoFieldScreen(String screenName) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
        this.tester.assertTextPresent("View Screens");
        this.tester.assertLinkPresent("configure_fieldscreen_" + screenName);
        this.tester.clickLink("configure_fieldscreen_" + screenName);
    }
}

