/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.Attachments;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class AttachmentsImpl
implements Attachments {
    private final WebTester tester;
    private final Navigation navigation;
    private final FuncTestLogger logger;

    @Inject
    public AttachmentsImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        this.tester = tester;
        this.logger = new FuncTestLoggerImpl(2);
        this.navigation = navigation;
    }

    @Override
    public void enable() {
        this.logger.log((Object)"Enabling attachments with default path.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.submit("Save");
    }

    @Override
    public void enable(String maxAttachmentSize) {
        this.logger.log((Object)("Enabling attachments with max size of : " + maxAttachmentSize));
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", maxAttachmentSize);
        this.tester.submit("Save");
    }

    @Override
    public void disable() {
        this.logger.log((Object)"Disabling attachments.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "false");
        this.tester.checkCheckbox("thumbnailsEnabled", "false");
        this.tester.checkCheckbox("zipSupport", "false");
        this.tester.submit("Save");
    }

    @Override
    public void enableZipSupport() {
        this.logger.log((Object)"Enabling ZIP support for downloading attachments.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("zipSupport", "true");
        this.tester.submit("Save");
    }

    @Override
    public void disableZipSupport() {
        this.logger.log((Object)"Disabling ZIP support for downloading attachments.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("zipSupport", "false");
        this.tester.submit("Save");
    }

    @Override
    public String getCurrentAttachmentPath() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        WebTable attachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("attachmentSettings");
        if ("Attachment path".equals(attachmentSettings.getCellAsText(2, 0).trim())) {
            String attachmentPath = attachmentSettings.getCellAsText(2, 1).trim();
            if (attachmentPath.startsWith("Default directory [")) {
                attachmentPath = attachmentPath.substring("Default directory [".length(), attachmentPath.length() - 1);
            }
            return attachmentPath;
        }
        throw new RuntimeException("Error occured when trying to screen-scrape the attachment path. 'Attachment path' not found where expected in the table.");
    }
}

