/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.util.dbc.Assertions;
import net.sourceforge.jwebunit.WebTester;

public interface IssueSecurityLevel {
    public IssueSecuritySchemes.IssueSecurityScheme scheme();

    public IssueSecurityLevel addIssueSecurity(IssueSecurity var1);

    public IssueSecurityLevel addIssueSecurity(IssueSecurity var1, String var2);

    public void delete();

    public void addRole(String var1);

    public static enum IssueSecurity {
        REPORTER("reporter", false),
        CURRENT_ASIGNEE("assignee", false),
        PROJECT_LEAD("lead", false),
        GROUP("group", true){
            private FormParameterUtil formParameterUtil;

            @Override
            void addParameter(WebTester tester, String paramValue) {
                Assertions.notNull("paramValue", paramValue);
                this.formParameterUtil = new FormParameterUtil(tester, "jiraform", " Add ");
                this.formParameterUtil.addOptionToHtmlSelect("group", new String[]{paramValue});
                this.formParameterUtil.setFormElement("group", paramValue);
            }

            @Override
            void submitForm(WebTester tester) {
                this.formParameterUtil.submitForm();
                tester.clickLinkWithText("Cancel");
            }
        }
        ,
        USER("user", true){

            @Override
            void addParameter(WebTester tester, String paramValue) {
                Assertions.notNull("paramValue", paramValue);
                tester.setFormElement(this.typeId(), paramValue);
            }
        }
        ,
        APPLICATION_ROLE("applicationRole", true){

            @Override
            void addParameter(WebTester tester, String paramValue) {
                Assertions.notNull("paramValue", paramValue);
                tester.setFormElement(this.typeId(), paramValue);
            }
        };

        private static final String ISSUE_SECURITY_TYPE_RADIO_NAME = "type";
        private final String typeId;
        private final boolean hasParameter;

        private IssueSecurity(String typeId, boolean hasParameter) {
            this.typeId = typeId;
            this.hasParameter = hasParameter;
        }

        public String typeId() {
            return this.typeId;
        }

        public boolean hasParameter() {
            return this.hasParameter;
        }

        final void chooseOnForm(WebTester tester) {
            if (this.hasParameter) {
                throw new IllegalStateException("this may be called ONLY for parameterless types");
            }
            this.chooseOnForm(tester, null);
        }

        final void chooseOnForm(WebTester tester, String paramValue) {
            if (!this.hasParameter && paramValue != null) {
                throw new IllegalArgumentException("param provided for parameterless issue security type");
            }
            tester.getDialog().setFormParameter(ISSUE_SECURITY_TYPE_RADIO_NAME, this.typeId);
            if (this.hasParameter) {
                this.addParameter(tester, paramValue);
            }
        }

        void submitForm(WebTester tester) {
            tester.submit();
        }

        void addParameter(WebTester tester, String paramValue) {
            throw new AbstractMethodError("should be implemented in relevant enum values");
        }
    }
}

