/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemesImpl;
import net.sourceforge.jwebunit.WebTester;

public class IssueSecurityLevelImpl
implements IssueSecurityLevel {
    private static final String ADD_SECURITY_LINK_ID_FORMAT = "add_%s";
    private final IssueSecuritySchemesImpl schemes;
    private final String name;
    private final String addSecurityLinkId;
    private final WebTester tester;

    public IssueSecurityLevelImpl(WebTester tester, IssueSecuritySchemesImpl schemes, String name) {
        this.tester = tester;
        this.schemes = schemes;
        this.name = name;
        this.addSecurityLinkId = this.createLinkId();
    }

    private String createLinkId() {
        return String.format(ADD_SECURITY_LINK_ID_FORMAT, this.name);
    }

    @Override
    public IssueSecuritySchemes.IssueSecurityScheme scheme() {
        return this.schemes;
    }

    @Override
    public IssueSecurityLevel addIssueSecurity(IssueSecurityLevel.IssueSecurity issueSecurity) {
        this.tester.clickLink(this.addSecurityLinkId);
        issueSecurity.chooseOnForm(this.tester);
        issueSecurity.submitForm(this.tester);
        return this;
    }

    @Override
    public IssueSecurityLevel addIssueSecurity(IssueSecurityLevel.IssueSecurity issueSecurity, String paramValue) {
        this.tester.clickLink(this.addSecurityLinkId);
        issueSecurity.chooseOnForm(this.tester, paramValue);
        issueSecurity.submitForm(this.tester);
        return this;
    }

    @Override
    public void delete() {
        this.tester.clickLink("delLevel_" + this.name);
        this.tester.assertTextPresent("Delete Issue Security Level: " + this.name);
        this.tester.submit("Delete");
    }

    @Override
    public void addRole(String roleName) {
        this.tester.clickLink("add_" + this.name);
        this.tester.getDialog().setFormParameter("type", "projectrole");
        this.tester.assertRadioOptionSelected("type", "projectrole");
        this.tester.selectOption("projectrole", roleName);
        this.tester.submit();
    }
}

