/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.Resolutions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;
import org.w3c.dom.Element;

public class ResolutionsImpl
implements Resolutions {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private Navigation navigation;

    @Inject
    public ResolutionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.navigation = null;
    }

    @Override
    public String addResolution(String name) {
        Element rowParent;
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.RESOLUTIONS);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", name);
        this.tester.submit("Add");
        XPathLocator locator = new XPathLocator(this.tester, "//tr/td/b[contains(.,'" + name + "')]");
        if (locator.getNodes().length != 1) {
            Fail.fail((String)("Could not find the newly created resolution '" + name + "'"));
        }
        if ((locator = new XPathLocator(rowParent = DomKit.getFirstParentByTag((Element)locator.getNodes()[0], "tr"), ".//a[contains(.,'Edit')]/@href")).getNodes().length != 1) {
            Fail.fail((String)("Could not find edit link for the newly created resolution '" + name + "'"));
        }
        String href = locator.getNodes()[0].getNodeValue();
        return href.substring(href.indexOf("=") + 1);
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }
}

