/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.DefaultRoleDetails;
import com.atlassian.jira.functest.framework.admin.RoleDetails;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;

public class RolesImpl
implements Roles {
    private static final String DELETE_ROLE = "/secure/project/DeleteProjectRole!default.jspa?id=";
    private static final String ADD_ROLE = "/secure/project/UserRoleActorAction!addUsers.jspa?projectRoleId=";
    private final WebTester tester;
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;
    private final RoleDetails roleDetails;
    private final FuncTestLogger logger;
    private Navigation navigation;

    public RolesImpl(WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData, int logIndentLevel) {
        this(tester, environmentData);
    }

    @Inject
    public RolesImpl(WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.roleDetails = new DefaultRoleDetails(tester);
        this.logger = new FuncTestLoggerImpl(2);
        this.navigation = null;
    }

    @Override
    public void delete(long roleId) {
        this.logger.log((Object)("Deleting project role " + roleId));
        this.tester.gotoPage(DELETE_ROLE + roleId);
        this.tester.submit("Delete");
    }

    @Override
    public void delete(String name) {
        this.logger.log((Object)("Deleting project role:" + name));
        this.gotoProjectRolesScreen();
        this.tester.clickLink("delete_" + name);
        this.tester.submit("Delete");
    }

    private void gotoProjectRolesScreen() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }

    @Override
    public void create(String name, String description) {
        this.gotoProjectRolesScreen();
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent(name);
        this.tester.assertTextPresent(description);
    }

    @Override
    public RoleDetails edit(String name) {
        this.gotoProjectRolesScreen();
        this.tester.clickLink("edit_" + name);
        return this.roleDetails;
    }

    private Project getProjectByName(String projectName) {
        ProjectClient projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        List projects = projectClient.getProjects();
        for (Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return project;
        }
        return null;
    }

    private void addUserToProjectRole(String userName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        if (projectByName == null) {
            Fail.fail((String)("A project with the name '" + projectName + "' does not exist."));
        }
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        ParsedResponse response = projectRoleClient.addActors(projectByName.key, roleName, null, new String[]{userName});
    }

    @Override
    public void addProjectRoleForUser(String projectName, String roleName, String userName) {
        this.addUserToProjectRole(userName, projectName, roleName);
    }
}

