/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin.user.shared;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.shared.SharedFiltersAdministration;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterTableParser;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class DefaultSharedFiltersAdministration
implements SharedFiltersAdministration {
    private final WebTester tester;
    private final Navigation navigation;
    private final LocatorFactory locators;

    @Inject
    public DefaultSharedFiltersAdministration(WebTester tester, Navigation navigation) {
        this.tester = tester;
        this.navigation = navigation;
        this.locators = new LocatorFactoryImpl(tester);
    }

    @Override
    public SharedFiltersAdministration goTo() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SHARED_FILTERS);
        return this;
    }

    @Override
    public SharedFiltersAdministration search(String searchText, String owner) {
        this.tester.setWorkingForm("search-filters-form");
        this.tester.setFormElement("searchName", searchText);
        this.tester.setFormElement("searchOwnerUserName", owner);
        this.tester.submit();
        return this;
    }

    @Override
    public SharedFiltersAdministration searchAll() {
        return this.search("", "");
    }

    @Override
    public SharedFiltersAdministration.Filters filters() {
        return new DefaultFilters(this.locators);
    }

    @Override
    public SharedFiltersAdministration deleteFilter(long filterId) {
        this.tester.clickLink(this.getDeleteLinkIdForFilter(filterId));
        this.tester.setWorkingForm(this.getDeleteConfirmationFormForFilterId(filterId));
        this.tester.submit();
        return this;
    }

    @Override
    public SharedFiltersAdministration changeFilterOwner(long filterId, String newOwner) {
        this.tester.clickLink(this.getChangeOwnerLinkIdForFilter(filterId));
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, this.getChangeOwnerFormForFilterId(filterId), "ChangeOwner");
        formParameterUtil.addOptionToHtmlSelect("owner", new String[]{newOwner});
        formParameterUtil.setFormElement("owner", newOwner);
        formParameterUtil.submitForm();
        this.tester.reset();
        return this.goTo().searchAll();
    }

    private String getDeleteLinkIdForFilter(long filterId) {
        return "delete_" + filterId;
    }

    private String getChangeOwnerLinkIdForFilter(long filterId) {
        return "change_owner_" + filterId;
    }

    private String getDeleteConfirmationFormForFilterId(long filterId) {
        return "delete-filter-confirm-form-" + filterId;
    }

    private String getChangeOwnerFormForFilterId(long filterId) {
        return "change-owner-form-" + filterId;
    }

    public static class DefaultFilters
    implements SharedFiltersAdministration.Filters {
        private final LocatorFactory locators;

        public DefaultFilters(LocatorFactory locators) {
            this.locators = locators;
        }

        @Override
        public List<FilterItem> list() {
            return new FilterTableParser(this.locators).parse("mf_browse");
        }
    }
}

