/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.DoesNotContainIssueKeyCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class IssueNavigatorAssertionsImpl
implements IssueNavigatorAssertions {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLogger logger;
    private final TextAssertions textAssertions;
    private Navigation navigation;

    @Inject
    public IssueNavigatorAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.textAssertions = new TextAssertionsImpl(tester);
        this.logger = new FuncTestLoggerImpl(2);
    }

    @Override
    public void assertSimpleSearch(NavigatorSearch search, WebTester tester) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)false).overridingErrorMessage("Fix to work with kickass", new Object[0])).isTrue();
    }

    @Override
    public void assertAdvancedSearch(WebTester tester, String ... values) {
        String jqlValue = tester.getDialog().getFormParameterValue("jqlQuery");
        for (String value : values) {
            ((AbstractStringAssert)Assertions.assertThat((String)jqlValue).overridingErrorMessage("The string '" + value + "' could not be found in the JQL '" + jqlValue + "'.", new Object[0])).contains(new CharSequence[]{value});
        }
    }

    @Override
    public void assertSearchInfo(SharedEntityInfo info) {
        XPathLocator locator = new XPathLocator(this.tester, "//*[@id='filter-description']");
        this.textAssertions.assertTextPresent(locator, info.getName());
        if (StringUtils.isNotBlank((CharSequence)info.getDescription())) {
            this.textAssertions.assertTextPresent(locator, info.getDescription());
        }
        boolean isFavourite = new XPathLocator(this.tester, "//a[starts-with(@id, 'fav_a_nav_SearchRequest_') and @title='Remove this filter from your favourites']").exists();
        boolean isNotFavourite = new XPathLocator(this.tester, "//a[starts-with(@id, 'fav_a_nav_SearchRequest_') and @title='Add this filter to your favourites']").exists();
        if (info.isFavourite()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)isFavourite).overridingErrorMessage("Should have been favourited but wasn't", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)isNotFavourite).overridingErrorMessage("Should not have been un-favourited but was", new Object[0])).isFalse();
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)isFavourite).overridingErrorMessage("Should not have been favourited but wasn't", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)isNotFavourite).overridingErrorMessage("Should have been un-favourited but wasn't", new Object[0])).isTrue();
        }
    }

    @Override
    public void assertSearchResults(Iterable<? extends SearchResultsCondition> conditions) {
        for (SearchResultsCondition searchResultsCondition : conditions) {
            searchResultsCondition.assertCondition(this.tester);
        }
    }

    @Override
    public void assertSearchResults(SearchResultsCondition ... conditions) {
        this.assertSearchResults(Arrays.asList(conditions));
    }

    @Override
    public void assertSearchResultsAreEmpty() {
        this.assertSearchResults((Iterable<? extends SearchResultsCondition>)ImmutableList.of((Object)new NumberOfIssuesCondition(this.textAssertions, 0)));
    }

    @Override
    public void assertExactIssuesInResults(String ... keys) {
        ArrayList<ContainsIssueKeysCondition> conditions = new ArrayList<ContainsIssueKeysCondition>();
        if (keys.length > 0) {
            conditions.add(new ContainsIssueKeysCondition(this.textAssertions, keys));
        }
        this.assertSearchResults(conditions);
    }

    @Override
    public void assertSearchResultsContain(String ... keys) {
        com.atlassian.jira.util.dbc.Assertions.notNull(keys);
        com.atlassian.jira.util.dbc.Assertions.is(!Iterables.isEmpty(Arrays.asList(keys)));
        this.assertSearchResults((Iterable<? extends SearchResultsCondition>)ImmutableList.of((Object)new ContainsIssueKeysCondition(this.textAssertions, keys)));
    }

    @Override
    public void assertSearchResultsDoNotContain(String ... keys) {
        com.atlassian.jira.util.dbc.Assertions.notNull(keys);
        com.atlassian.jira.util.dbc.Assertions.is(!Iterables.isEmpty(Arrays.asList(keys)));
        this.assertSearchResults(Iterables.transform(Arrays.asList(keys), (Function)new Function<String, SearchResultsCondition>(){

            public SearchResultsCondition apply(@Nullable String input) {
                return new DoesNotContainIssueKeyCondition(IssueNavigatorAssertionsImpl.this.textAssertions, input);
            }
        }));
    }

    @Override
    public void assertJqlErrors(String ... errorMessages) {
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "jqlerror"), errorMessages);
    }

    @Override
    public void assertJqlWarnings(String ... warningMessages) {
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "jqlwarning"), warningMessages);
    }

    @Override
    public void assertJqlTooComplex() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Object)this.getNavigation().issueNavigator().getCurrentEditMode())).overridingErrorMessage("Should be on the advanced view.", new Object[0])).isEqualTo((Object)this.getNavigation().issueNavigator().getCurrentEditMode());
        IdLocator locator = new IdLocator(this.tester, "filter-switch");
        this.textAssertions.assertTextSequence(locator, "This query is too complex to display in Simple mode.", new String[0]);
    }

    @Override
    public void assertNoJqlErrors() {
        Assertions.assertThat((Object[])new IdLocator(this.tester, "jqlerror").getNodes()).hasSize(0);
        Assertions.assertThat((Object[])new IdLocator(this.tester, "jqlwarning").getNodes()).hasSize(0);
    }

    @Override
    public void assertJqlFitsInFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        this.logger.log((Object)("Asserting fits filter: '" + jqlQuery + "' with params: " + Arrays.asList(formParams)));
        this.getNavigation().issueNavigator().createSearch(jqlQuery);
        this.getNavigation().issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        for (IssueNavigatorAssertions.FilterFormParam formParam : formParams) {
            this.tester.setWorkingForm("issue-filter");
            IssueNavigatorAssertionsImpl.assertSameElements(formParam.getValues(), this.tester.getDialog().getForm().getParameterValues(formParam.getName()));
        }
    }

    private static void assertSameElements(String[] a, String[] b) {
        HashSet<String> as = a == null || a.length == 0 ? null : new HashSet<String>(Arrays.asList(a));
        HashSet<String> bs = b == null || b.length == 0 ? null : new HashSet<String>(Arrays.asList(b));
        Assertions.assertThat((Collection)bs).isEqualTo(as);
    }

    @Override
    public void assertIssueNavigatorDisplaying(Locator locator, String from, String to, String of) {
        this.textAssertions.assertTextSequence(locator, new String[]{from, "\u2013", to, "of", of});
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }
}

