/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public class JiraFormAssertionsImpl
implements JiraFormAssertions {
    private static final String AUI_MESSAGE_ERROR_CSS = ".aui-message.aui-message-error";
    private static final String AUI_MESSAGE_WARNING_CSS = ".aui-message.aui-message-warning";
    private static final String AUI_MESSAGE_INFO_CSS = ".aui-message.aui-message-info";
    private final TextAssertions textAssertions;
    private final WebTester tester;
    private final LocatorFactory locators;

    @Inject
    public JiraFormAssertionsImpl(TextAssertions textAssertions, WebTester tester, JIRAEnvironmentData environmentData) {
        this.textAssertions = textAssertions;
        this.tester = tester;
        this.locators = new LocatorFactoryImpl(tester);
    }

    @Override
    public void assertFieldErrMsg(String expectedText) {
        Locator error = this.createFieldErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertAuiFieldErrMsg(String expectedText) {
        Locator error = this.createAuiFieldErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertFormErrMsg(String expectedText) {
        Locator error = this.createFormErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertFormErrMsgContainsLink(String linkExactText) {
        CssLocator linksInErrorMsg = this.locators.css(".aui-message.aui-message-error a");
        if (!this.nodeWithTextExists(linkExactText, linksInErrorMsg)) {
            Assertions.fail((String)("Link with text '" + linkExactText + "' not found in any error message"));
        }
    }

    private boolean nodeWithTextExists(String linkExactText, Locator linksInErrorMsg) {
        for (LocatorEntry link : linksInErrorMsg.allMatches()) {
            if (!linkExactText.equals(link.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assertNoFieldErrMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFieldErrorMessageLocator(), notExpectedText);
    }

    @Override
    public void assertNoFormErrMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormErrorMessageLocator(), notExpectedText);
    }

    @Override
    public void assertNoErrorsPresent() {
        Locator errorLocator = this.createFieldErrorMessageLocator();
        ((ObjectAssert)Assertions.assertThat((Object)errorLocator.getNode()).overridingErrorMessage("Expected no errors on the page, but there was a field with an error.", new Object[0])).isNull();
        errorLocator = this.createFormErrorMessageLocator();
        ((ObjectAssert)Assertions.assertThat((Object)errorLocator.getNode()).overridingErrorMessage("Expected no errors on the page, but the page had a global error.", new Object[0])).isNull();
    }

    @Override
    public void assertFormNotificationMsg(String expectedText) {
        Locator notification = this.createFormNotificationMessageLocator();
        this.textAssertions.assertTextPresent(notification, expectedText);
    }

    @Override
    public void assertNoFormNotificationMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormNotificationMessageLocator(), notExpectedText);
    }

    @Override
    public void assertFormNotificationMsgContainsLink(String linkExactText) {
        CssLocator linksInErrorMsg = this.locators.css(".aui-message.aui-message-info a");
        if (!this.nodeWithTextExists(linkExactText, linksInErrorMsg)) {
            Assertions.fail((String)("Link with text '" + linkExactText + "' not found in any notification message"));
        }
    }

    @Override
    public void assertFormSuccessMsg(String expectedText) {
        Locator notification = this.createFormSuccessMessageLocator();
        this.textAssertions.assertTextPresent(notification, expectedText);
    }

    @Override
    public void assertFormWarningMessage(String messageText) {
        this.textAssertions.assertTextPresent(this.createFormWarningMessageLocator(), messageText);
    }

    @Override
    public void assertNoFormWarningMessage(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormWarningMessageLocator(), notExpectedText);
    }

    @Override
    public void assertFormWarningMessageContainsLink(String linkExactText) {
        CssLocator linksInMsg = this.locators.css(".aui-message.aui-message-warning a");
        if (!this.nodeWithTextExists(linkExactText, linksInMsg)) {
            Assertions.fail((String)("Link with text '" + linkExactText + "' not found in any warning message"));
        }
    }

    @Override
    public void assertSelectElementHasOptionSelected(String selectElementName, String optionName) {
        String actual = this.tester.getDialog().getSelectedOption(selectElementName);
        ((AbstractStringAssert)Assertions.assertThat((String)actual).overridingErrorMessage("Expected option selected '" + optionName + "' was not selected in form element '" + selectElementName + "'. Actual selected option was '" + actual + "'.", new Object[0])).isEqualTo(optionName);
    }

    @Override
    public void assertSelectElementByIdHasOptionSelected(String selectElementId, String optionName) {
        List<String> selectedOptionIds = Arrays.asList(this.tester.getDialog().getForm().getParameterValues(selectElementId));
        String[] optionValues = this.tester.getDialog().getOptionsFor(selectElementId);
        for (int i = 0; i < optionValues.length; ++i) {
            String optionValue = optionValues[i];
            if (!optionValue.equals(optionName)) continue;
            String expectedValueId = this.tester.getDialog().getOptionValuesFor(selectElementId)[i];
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)selectedOptionIds.contains(expectedValueId)).overridingErrorMessage("Expected option '" + optionName + "' for element '" + selectElementId + "' was not selected", new Object[0])).isTrue();
            return;
        }
        Assertions.fail((String)("Expected option value: '" + optionName + "' is not a selected value option for '" + selectElementId + "'"));
    }

    @Override
    public void assertSelectElementByIdHasOptionSelectedById(String selectElementId, String optionId) {
        List<String> selectedOptionIds = Arrays.asList(this.tester.getDialog().getForm().getParameterValues(selectElementId));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)selectedOptionIds.contains(optionId)).overridingErrorMessage("Expected selected option '" + optionId + "' for element '" + selectElementId + "'.", new Object[0])).isTrue();
    }

    private Locator createFieldErrorMessageLocator() {
        return new XPathLocator(this.tester, "//span[@class='errMsg']");
    }

    private Locator createAuiFieldErrorMessageLocator() {
        return new XPathLocator(this.tester, "//form[@class='aui']//div[@class='field-group']//div[@class='error']");
    }

    private Locator createFormErrorMessageLocator() {
        return this.locators.css(AUI_MESSAGE_ERROR_CSS);
    }

    private Locator createFormNotificationMessageLocator() {
        return this.locators.css(AUI_MESSAGE_INFO_CSS);
    }

    private Locator createFormSuccessMessageLocator() {
        return this.locators.css(".aui-message.aui-message-success");
    }

    private Locator createFormWarningMessageLocator() {
        return this.locators.css(AUI_MESSAGE_WARNING_CSS);
    }
}

