/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectArrayAssert;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LinkAssertionsImpl
implements LinkAssertions {
    private static final String LITERAL_PLUS = "\\+";
    private final WebTester tester;
    private final LocatorFactory locators;

    @Inject
    public LinkAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.locators = new LocatorFactoryImpl(tester);
    }

    @Override
    public void assertLinkByIdHasExactText(String linkId, String linkText) {
        CssLocator locator = this.locators.css("a#" + linkId);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)locator.hasNodes()).overridingErrorMessage("Could not find link with ID '" + linkId + "'", new Object[0])).isTrue();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])locator.getNodes()).overridingErrorMessage("Page is corrupted. Found more than 1 link with ID '" + linkId + "'", new Object[0])).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)locator.getText()).overridingErrorMessage("Unexpected text of the located link with ID '" + linkId + "'", new Object[0])).isEqualTo(locator.getText());
    }

    @Override
    public void assertLinkLocationEndsWith(String linkText, String endsWith) {
        WebLink webLink = this.getLinkWithText(linkText);
        String urlString = webLink.getURLString().trim();
        ((AbstractStringAssert)Assertions.assertThat((String)urlString).as("Location of link with text '" + linkText + "' expected to end with '" + endsWith + "' but points to '" + urlString + "'.", new Object[0])).endsWith((CharSequence)endsWith);
    }

    @Override
    public void assertLinkLocationEndsWith(WebLink link, String endsWith) {
        String urlString = link.getURLString().trim();
        ((AbstractStringAssert)Assertions.assertThat((String)urlString).as("Location of link expected to end with '" + endsWith + "' but points to '" + urlString + "'.", new Object[0])).endsWith((CharSequence)endsWith);
    }

    @Override
    public void assertLinkAtNodeEndsWith(String xpath, String endsWith) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)locator.exists()).overridingErrorMessage("Node '" + xpath + "' does not exist.", new Object[0])).isTrue();
        String href = locator.getNode().getAttributes().getNamedItem("href").getNodeValue();
        if (!href.endsWith(endsWith)) {
            Fail.fail((String)("Location of link expected to end with '" + endsWith + "' but points to '" + href + "'."));
        }
    }

    @Override
    public void assertLinkAtNodeContains(String xpath, String containsUrl) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)locator.exists()).overridingErrorMessage("Node '" + xpath + "' does not exist.", new Object[0])).isTrue();
        String href = locator.getNode().getAttributes().getNamedItem("href").getNodeValue();
        if (!href.contains(containsUrl)) {
            Fail.fail((String)("Location of link expected to contain '" + containsUrl + "' but points to '" + href + "'."));
        }
    }

    @Override
    public void assertLinkIdQueryStringContainsJqlQuery(String linkId, String expectedJqlQuery) {
        this.assertLinkQueryStringContainsJqlQuery(this.getLinkWithId(linkId), expectedJqlQuery);
    }

    @Override
    public void assertLinkTextQueryStringContainsJqlQuery(String xpath, String linkText, String expectedJqlQuery) {
        List<String> hrefs = this.getHrefsFromLinkNodeWithExactText(xpath, linkText);
        for (String href : hrefs) {
            boolean found = this.doesHrefContainsJqlQuery(href, expectedJqlQuery);
            if (!found) continue;
            return;
        }
        Fail.fail((String)String.format("Could not find any links with text '%s' in xpath '%s' that contained the jql '%s'", linkText, xpath, expectedJqlQuery));
    }

    @Override
    public void assertLinkQueryStringContainsJqlQuery(WebLink link, String expectedJqlQuery) {
        if (StringUtils.isEmpty((CharSequence)link.getURLString())) {
            Fail.fail((String)("No URL for link with id [" + link.getID() + "]"));
        }
        boolean foundSubString = this.doesHrefContainsJqlQuery(link.getURLString(), expectedJqlQuery);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)foundSubString).overridingErrorMessage(String.format("Could not find jql '%s' in URL '%s'", expectedJqlQuery, link.getURLString()), new Object[0])).isTrue();
    }

    private boolean doesHrefContainsJqlQuery(String href, String expectedJqlQuery) {
        try {
            String urlSubstringWithPlusses = "jql=" + URLEncoder.encode(expectedJqlQuery, "UTF-8");
            return href.contains(urlSubstringWithPlusses) || href.contains(urlSubstringWithPlusses.replaceAll(LITERAL_PLUS, "%20"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void assertLinkIdLocationEndsWith(String linkId, String endsWith) {
        WebLink webLink = this.getLinkWithId(linkId);
        String urlString = webLink.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Fail.fail((String)("Location of link with id '" + linkId + "' expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkIdLocationMatchesRegex(String linkId, String regex) {
        WebLink webLink = this.getLinkWithId(linkId);
        String urlString = webLink.getURLString().trim();
        if (!urlString.matches(regex)) {
            Fail.fail((String)("Location of link with id '" + linkId + "' expected to match regex '" + regex + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkPresentWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a[text()=\"" + text + "\"]");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])locator.getNodes()).overridingErrorMessage("Could not find a single link with the exact text \"" + text + "\" using locator: " + locator, new Object[0])).isNotEmpty();
    }

    @Override
    public void assertLinkNotPresentWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a[text()=\"" + text + "\"]");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])locator.getNodes()).overridingErrorMessage("Found a link with the exact text \"" + text + "\" using locator: " + locator, new Object[0])).isEmpty();
    }

    @Override
    public void assertLinkPresentWithExactTextById(String regionId, String text) {
        com.atlassian.jira.util.dbc.Assertions.notNull("regionId", regionId);
        com.atlassian.jira.util.dbc.Assertions.notNull("text", text);
        CssLocator allLinks = this.locators.css("#" + regionId + " a");
        for (LocatorEntry singleLink : allLinks.allMatches()) {
            if (!text.equals(singleLink.getText())) continue;
            return;
        }
        Fail.fail((String)("Link with text '" + text + "' not found within section with ID '" + regionId + "'"));
    }

    @Override
    public void assertLinkNotPresentContainingTextById(String regionId, String text) {
        com.atlassian.jira.util.dbc.Assertions.notNull("regionId", regionId);
        com.atlassian.jira.util.dbc.Assertions.notNull("text", text);
        CssLocator allLinks = this.locators.css("#" + regionId + " a");
        for (LocatorEntry singleLink : allLinks.allMatches()) {
            ((AbstractStringAssert)Assertions.assertThat((String)singleLink.getText()).overridingErrorMessage("Not expected link with text '" + text + "' found within section with ID '" + regionId + "'", new Object[0])).doesNotContain(new CharSequence[]{text});
        }
    }

    @Override
    public void assertLinkWithExactTextAndUrlPresent(String expectedExactText, String expectedUrlSuffix) {
        for (String href : this.getHrefsFromLinkNodeWithExactText("", expectedExactText)) {
            if (!href.endsWith(expectedUrlSuffix)) continue;
            return;
        }
        Fail.fail((String)("No link with exact text '" + expectedExactText + "' and URL suffix '" + expectedUrlSuffix + "' found"));
    }

    private List<String> getHrefsFromLinkNodeWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a");
        if (locator.getNodes().length == 0) {
            throw new IllegalArgumentException("Could not find any links with the text '" + text + "' from xpath '" + xpath + "'.");
        }
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        for (Node node : locator.getNodes()) {
            String nodeText = locator.getText(node);
            if (!text.equals(nodeText)) continue;
            matchedNodes.add(node);
        }
        ArrayList<String> hrefs = new ArrayList<String>();
        for (Node aNode : matchedNodes) {
            hrefs.add(aNode.getAttributes().getNamedItem("href").getNodeValue());
        }
        return hrefs;
    }

    private WebLink getLinkWithText(String text) {
        WebLink webLink;
        try {
            HttpUnitDialog dialog = this.tester.getDialog();
            if (!dialog.isLinkPresentWithText(text)) {
                Fail.fail((String)("Link with text'" + text + "' does not exist."));
            }
            webLink = dialog.getResponse().getLinkWith(text);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Link with text '" + text + "' does not exist."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        return webLink;
    }

    private WebLink getLinkWithId(String linkId) {
        WebLink webLink;
        try {
            HttpUnitDialog dialog = this.tester.getDialog();
            if (!dialog.isLinkPresent(linkId)) {
                Fail.fail((String)("Link with id'" + linkId + "' does not exist."));
            }
            webLink = dialog.getResponse().getLinkWithID(linkId);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Link with id '" + linkId + "' does not exist."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        return webLink;
    }
}

