/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.URLAssertions;
import com.atlassian.jira.functest.framework.util.url.ParsedURL;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.net.URL;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;

public class URLAssertionsImpl
implements URLAssertions {
    private final WebTester tester;

    @Inject
    public URLAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
    }

    @Override
    public void assertCurrentURLPathEndsWith(String expectedEnd) {
        String actualPath = this.getCurrentURL().getPath();
        ((AbstractStringAssert)Assertions.assertThat((String)actualPath).overridingErrorMessage("Expected path to end with '" + expectedEnd + "' but was '" + actualPath + "'.", new Object[0])).endsWith((CharSequence)expectedEnd);
    }

    @Override
    public void assertCurrentURLEndsWith(String expectedEnd) {
        String actualPath = this.getCurrentURL().toExternalForm();
        ((AbstractStringAssert)Assertions.assertThat((String)actualPath).overridingErrorMessage("Expected url to end with '" + expectedEnd + "' but was '" + actualPath + "'.", new Object[0])).endsWith((CharSequence)expectedEnd);
    }

    @Override
    public void assertCurrentURLMatchesRegex(String regex) {
        String actualPath = this.getCurrentURL().toExternalForm();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualPath.matches(regex)).overridingErrorMessage("Current URL '" + actualPath + "' did not match regular expression '" + regex + "'.", new Object[0])).isTrue();
    }

    @Override
    public void assertURLAreSimilair(String msg, String expectedURL, String actualURL) {
        ParsedURL parsedURL1 = new ParsedURL(expectedURL);
        ParsedURL parsedURL2 = new ParsedURL(actualURL);
        ((AbstractStringAssert)Assertions.assertThat((String)parsedURL2.getPath()).overridingErrorMessage(msg + " - not the same path! URL1:'" + parsedURL1 + "' URL2:'" + parsedURL2 + "'", new Object[0])).isEqualTo(parsedURL1.getPath());
        ((MapAssert)Assertions.assertThat(parsedURL2.getMultiQueryParameters()).overridingErrorMessage(msg + " - not the same query params! URL1:'" + parsedURL1 + "' URL2:'" + parsedURL2 + "'", new Object[0])).isEqualTo(parsedURL1.getMultiQueryParameters());
    }

    private URL getCurrentURL() {
        return this.tester.getDialog().getResponse().getURL();
    }
}

