/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class UserAssertions {
    private final WebTester tester;
    private final Assertions assertions;

    @Inject
    public UserAssertions(WebTester tester, JIRAEnvironmentData environmentData, Assertions assertions) {
        this.tester = tester;
        this.assertions = assertions;
    }

    public boolean userExists(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        return this.tester.getDialog().getResponseText().contains("Account information");
    }

    public void assertUserExists(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.tester.assertTextNotPresent("This user does not exist");
    }

    public void assertUserDoesNotExist(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.tester.assertTextPresent("This user does not exist");
    }

    public void assertUserDetails(String username, String displayName, String emailAddress, String directoryName) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.tester.assertTextNotPresent("This user does not exist");
        this.assertions.assertNodeByIdEquals("username", username);
        this.assertions.assertNodeByIdEquals("displayName", displayName);
        this.tester.assertTextPresent("href=\"mailto:" + emailAddress + '\"');
        this.assertions.assertNodeByIdEquals("directory", directoryName);
    }

    public void assertGroupExists(String name) {
        this.tester.gotoPage("/secure/admin/user/ViewGroup.jspa?name=" + name);
        this.tester.assertTextNotPresent("The group does not exist");
    }

    public void assertGroupDoesNotExist(String name) {
        this.tester.gotoPage("/secure/admin/user/ViewGroup.jspa?name=" + name);
        this.tester.assertTextPresent("The group does not exist");
    }

    public void assertUserBelongsToGroup(String username, String groupname) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.assertions.assertNodeByIdHasText("groups", groupname);
    }

    public void assertUserDoesNotBelongToGroup(String username, String groupname) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.assertions.assertNodeByIdDoesNotHaveText("groups", groupname);
    }
}

