/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public final class AdvancedAuditingClient
extends RestApiClient<AdvancedAuditingClient> {
    private final JIRAEnvironmentData environmentData;

    public AdvancedAuditingClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
    }

    public void allAreasTo(String coverageLevel) {
        this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("auditing").path("1.0").path("configuration").path("coverage").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json(this.createBody(coverageLevel)), String.class);
    }

    public List<AuditEntities> takeAllEvents() {
        return ((ViewResponse)this.createResource().request().get(ViewResponse.class)).entities;
    }

    public List<AuditEntities> takeAllEvents(int limit) {
        return ((ViewResponse)this.createResource().queryParam("limit", new Object[]{String.valueOf(limit)}).request().get(ViewResponse.class)).entities;
    }

    public List<AuditEntities> takeAllEventsWithAffectedObject(String affectedObjectType, String affectedObjectId) {
        return ((ViewResponse)this.createResource().queryParam("affectedObject", new Object[]{String.join((CharSequence)",", affectedObjectType, affectedObjectId)}).request().get(ViewResponse.class)).entities;
    }

    public AuditEntities waitUntilEventIsFound(String eventSummary) {
        return this.waitUntilEventIsFound(eventSummary, 300);
    }

    public AuditEntities waitUntilEventIsFound(String eventSummary, int secondsAtMost) {
        AtomicReference entities = new AtomicReference(Optional.empty());
        Awaitility.await().atMost((long)secondsAtMost, TimeUnit.SECONDS).pollInterval(Duration.FIVE_SECONDS).until(() -> {
            Optional<AuditEntities> optionalEvent = this.takeAllEvents().stream().filter(entity -> entity.getType().getAction().equals(eventSummary)).findAny();
            entities.set(optionalEvent);
            return optionalEvent.isPresent();
        });
        return (AuditEntities)entities.get().orElseThrow(IllegalStateException::new);
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("auditing").path("1.0").path("events");
    }

    private Map<String, Object> createBody(final String coverageLevel) {
        return new HashMap<String, Object>(){
            {
                this.put("levelByArea", new HashMap<String, Object>(){
                    {
                        this.put("end-user-activity", coverageLevel);
                        this.put("security", coverageLevel);
                        this.put("ecosystem", coverageLevel);
                        this.put("global-config-and-administration", coverageLevel);
                        this.put("permissions", coverageLevel);
                        this.put("local-config-and-administration", coverageLevel);
                        this.put("audit-log", coverageLevel);
                        this.put("user-management", coverageLevel);
                    }
                });
            }
        };
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginationInfo {
        @JsonProperty
        private boolean lastPage;
        @JsonProperty
        private int size;

        public PaginationInfo() {
        }

        public PaginationInfo(boolean lastPage, int size) {
            this.lastPage = lastPage;
            this.size = size;
        }

        public boolean isLastPage() {
            return this.lastPage;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaginationInfo that = (PaginationInfo)o;
            return this.lastPage == that.lastPage && this.size == that.size;
        }

        public int hashCode() {
            return Objects.hash(this.lastPage, this.size);
        }
    }

    public static class AuditAuthorEntity {
        @JsonProperty
        private String id;
        @JsonProperty
        private String type;
        @JsonProperty
        private String name;
        @JsonProperty
        private String uri;

        public AuditAuthorEntity() {
        }

        public AuditAuthorEntity(String id, String type, String name, String uri) {
            this.id = id;
            this.type = type;
            this.name = name;
            this.uri = uri;
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditAuthorEntity that = (AuditAuthorEntity)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.uri, that.uri);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type, this.name, this.uri);
        }

        public String toString() {
            return "AuditAuthorEntity{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", uri='" + this.uri + '\'' + '}';
        }
    }

    public static class AuditTypeEntity {
        @JsonProperty
        private String category;
        @JsonProperty
        private String action;
        @JsonProperty
        private String categoryI18nKey;
        @JsonProperty
        private String actionI18nKey;

        public String getCategory() {
            return this.category;
        }

        public String getAction() {
            return this.action;
        }

        public String getCategoryI18nKey() {
            return this.categoryI18nKey;
        }

        public String getActionI18nKey() {
            return this.actionI18nKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditTypeEntity that = (AuditTypeEntity)o;
            return Objects.equals(this.category, that.category) && Objects.equals(this.action, that.action);
        }

        public int hashCode() {
            return Objects.hash(this.category, this.action);
        }

        public String toString() {
            return "AuditTypeEntity{category='" + this.category + '\'' + ", action='" + this.action + '\'' + ", categoryI18nKey='" + this.categoryI18nKey + '\'' + ", actionI18nKey='" + this.actionI18nKey + '\'' + '}';
        }
    }

    public static class AuditAffectedObjects {
        @JsonProperty
        private String name;
        @JsonProperty
        private String type;
        @JsonProperty
        private String uri;
        @JsonProperty
        private String id;

        public AuditAffectedObjects() {
        }

        public AuditAffectedObjects(String name, String type, String uri, String id) {
            this.name = name;
            this.type = type;
            this.uri = uri;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getUri() {
            return this.uri;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditAffectedObjects that = (AuditAffectedObjects)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.uri, that.uri) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.uri, this.id);
        }

        public String toString() {
            return "AuditAffectedObjects{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", uri='" + this.uri + '\'' + ", id='" + this.id + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuditChangedValuesEntity {
        @JsonProperty
        private String key;
        @JsonProperty
        private String i18nKey;
        @JsonProperty
        private String from;
        @JsonProperty
        private String to;

        public AuditChangedValuesEntity() {
        }

        public AuditChangedValuesEntity(String key, String i18nKey, String from, String to) {
            this.key = key;
            this.i18nKey = i18nKey;
            this.from = from;
            this.to = to;
        }

        public String getKey() {
            return this.key;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditChangedValuesEntity that = (AuditChangedValuesEntity)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.i18nKey, that.i18nKey) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.i18nKey, this.from, this.to);
        }

        public String toString() {
            return "AuditChangedValuesEntity{key='" + this.key + '\'' + ", i18nKey='" + this.i18nKey + '\'' + ", from='" + this.from + '\'' + ", to='" + this.to + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuditExtraAttributes {
        @JsonProperty
        private String name;
        @JsonProperty
        private String value;

        public AuditExtraAttributes() {
        }

        public AuditExtraAttributes(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditExtraAttributes that = (AuditExtraAttributes)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "AuditExtraAttributes{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuditEntities {
        @JsonProperty
        private Date timestamp;
        @JsonProperty
        private AuditAuthorEntity auditAuthor;
        @JsonProperty
        private AuditTypeEntity type;
        @JsonProperty
        private List<AuditAffectedObjects> affectedObjects;
        @JsonProperty
        private List<AuditChangedValuesEntity> changedValues;
        @JsonProperty
        private String source;
        @JsonProperty
        private String system;
        @JsonProperty
        private String method;
        @JsonProperty
        private List<AuditExtraAttributes> extraAttributes;

        public AuditEntities() {
        }

        public AuditEntities(Date timestamp, AuditAuthorEntity auditAuthor, AuditTypeEntity type, List<AuditAffectedObjects> affectedObjects, List<AuditChangedValuesEntity> changedValues, String source, String system, String method, List<AuditExtraAttributes> extraAttributes) {
            this.timestamp = timestamp;
            this.auditAuthor = auditAuthor;
            this.type = type;
            this.affectedObjects = affectedObjects;
            this.changedValues = changedValues;
            this.source = source;
            this.system = system;
            this.method = method;
            this.extraAttributes = extraAttributes;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public AuditAuthorEntity getAuditAuthor() {
            return this.auditAuthor;
        }

        public AuditTypeEntity getType() {
            return this.type;
        }

        public List<AuditAffectedObjects> getAffectedObjects() {
            return this.affectedObjects;
        }

        public List<AuditChangedValuesEntity> getChangedValues() {
            return this.changedValues;
        }

        public String getSource() {
            return this.source;
        }

        public String getSystem() {
            return this.system;
        }

        public String getMethod() {
            return this.method;
        }

        public List<AuditExtraAttributes> getExtraAttributes() {
            return this.extraAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditEntities that = (AuditEntities)o;
            return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.auditAuthor, that.auditAuthor) && Objects.equals(this.type, that.type) && Objects.equals(this.affectedObjects, that.affectedObjects) && Objects.equals(this.changedValues, that.changedValues) && Objects.equals(this.source, that.source) && Objects.equals(this.system, that.system) && Objects.equals(this.method, that.method) && Objects.equals(this.extraAttributes, that.extraAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.auditAuthor, this.type, this.affectedObjects, this.changedValues, this.source, this.system, this.method, this.extraAttributes);
        }

        public String toString() {
            return "AuditEntities{timestamp=" + this.timestamp + ", auditAuthor=" + this.auditAuthor + ", type=" + this.type + ", affectedObjects=" + this.affectedObjects + ", changedValues=" + this.changedValues + ", source='" + this.source + '\'' + ", system='" + this.system + '\'' + ", method='" + this.method + '\'' + ", extraAttributes=" + this.extraAttributes + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ViewResponse {
        @JsonProperty
        private PaginationInfo pagingInfo;
        @JsonProperty
        private List<AuditEntities> entities;

        public ViewResponse() {
        }

        public ViewResponse(PaginationInfo pagingInfo, List<AuditEntities> entities) {
            this.pagingInfo = pagingInfo;
            this.entities = entities;
        }

        public PaginationInfo getPagingInfo() {
            return this.pagingInfo;
        }

        public List<AuditEntities> getEntities() {
            return this.entities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewResponse that = (ViewResponse)o;
            return Objects.equals(this.pagingInfo, that.pagingInfo) && Objects.equals(this.entities, that.entities);
        }

        public int hashCode() {
            return Objects.hash(this.pagingInfo, this.entities);
        }
    }
}

