/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.NotImplementedException;

public class IndexingControl
extends BackdoorControl<IndexingControl> {
    public IndexingControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    @Nonnull
    public IndexingProgress startInBackground() {
        return this.startInBackground(IssueIndexingParams.INDEX_ISSUE_ONLY);
    }

    @Nonnull
    public IndexingProgress startInBackground(IssueIndexingParams issueIndexingParams) {
        final String taskId = (String)this.createResource().path("indexing").path("background").queryParam("comments", new Object[]{String.valueOf(issueIndexingParams.isIndexComments())}).queryParam("changeHistory", new Object[]{String.valueOf(issueIndexingParams.isIndexChangeHistory())}).queryParam("worklogs", new Object[]{String.valueOf(issueIndexingParams.isIndexWorklogs())}).queryParam("issues", new Object[]{String.valueOf(issueIndexingParams.isIndexIssues())}).request().post(null, String.class);
        return new IndexingProgress(){

            @Override
            boolean isIndexing() {
                return IndexingControl.this.isIndexingInProgress();
            }

            @Override
            boolean isIndexingStarted() {
                return IndexingControl.this.checkIsIndexingStarted();
            }

            @Override
            public String getTaskId() {
                return taskId;
            }
        };
    }

    @Nonnull
    public IndexingProgress startStopTheWorldReIndex() {
        this.createResource().path("indexing").path("stoptheworld").request().post(null, String.class);
        return new DefaultIndexingProgress();
    }

    @Nullable
    public Boolean isReindexTaskSuccessful(String taskId) {
        Map rawValues = (Map)this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("reindex").queryParam("taskId", new Object[]{taskId}).request().get(Map.class);
        return (Boolean)rawValues.get("success");
    }

    @Nullable
    public int getIndexingTaskProgress(String taskId) {
        Map rawValues = (Map)this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("reindex").queryParam("taskId", new Object[]{taskId}).request().get(Map.class);
        return (Integer)rawValues.get("currentProgress");
    }

    @Nonnull
    public IndexingProgress getInBackgroundProgress() {
        return new DefaultIndexingProgress();
    }

    boolean isIndexingInProgress() {
        return (Boolean)this.createResource().path("indexing").request().get(Boolean.class);
    }

    boolean checkIsIndexingStarted() {
        return (Boolean)this.createResource().path("indexing").path("started").request().get(Boolean.class);
    }

    @Nonnull
    public IndexingProgress getProjectIndexingProgress(final Long projectId) {
        return new IndexingProgress(){

            @Override
            public long getProgress() {
                return IndexingControl.this.getIndexingProgress(projectId);
            }

            @Override
            boolean isIndexing() {
                return IndexingControl.this.isIndexingProject(projectId);
            }

            @Override
            boolean isIndexingStarted() {
                return IndexingControl.this.isIndexingProjectStarted(projectId);
            }

            @Override
            public String getTaskId() {
                return null;
            }
        };
    }

    long getIndexingProgress(Long projectId) {
        return (Long)this.createResource().path("indexing").path("project").path("progress").queryParam("projectId", new Object[]{projectId.toString()}).request().get(Long.class);
    }

    boolean isIndexingProject(Long projectId) {
        return (Boolean)this.createResource().path("indexing").path("project").queryParam("projectId", new Object[]{projectId.toString()}).request().get(Boolean.class);
    }

    boolean isIndexingProjectStarted(Long projectId) {
        return (Boolean)this.createResource().path("indexing").path("project").path("started").queryParam("projectId", new Object[]{projectId.toString()}).request().get(Boolean.class);
    }

    public boolean isIndexConsistent() {
        return (Boolean)this.createResource().path("indexing").path("consistent").request().get(Boolean.class);
    }

    public boolean isIndexUpdatedFieldConsistent() {
        return (Boolean)this.createResource().path("indexing").path("consistent").path("updated").request().get(Boolean.class);
    }

    public void deleteIndex() {
        this.createResource().path("indexing").path("deleteIndex").request().post(null, String.class);
    }

    public void deleteIndexDirectory(boolean issues, boolean comments, boolean worklogs, boolean history) {
        this.createResource().path("indexing").path("deleteIndexDirectory").queryParam("issues", new Object[]{String.valueOf(issues)}).queryParam("comments", new Object[]{String.valueOf(comments)}).queryParam("worklogs", new Object[]{String.valueOf(worklogs)}).queryParam("history", new Object[]{String.valueOf(history)}).request().post(null, String.class);
    }

    public void deindex(String issueKey) {
        this.createResource().path("indexing").path("deindex").queryParam("key", new Object[]{issueKey}).request().get(Boolean.class);
    }

    public void indexDummyIssue(long id, long projectId, String issueType, String issueKey, String summary, String desc) {
        this.createResource().path("indexing").path("indexDummyIssue").queryParam("id", new Object[]{String.valueOf(id)}).queryParam("projectId", new Object[]{String.valueOf(projectId)}).queryParam("issueType", new Object[]{issueType}).queryParam("key", new Object[]{issueKey}).queryParam("summary", new Object[]{summary}).queryParam("description", new Object[]{desc}).request().get(Boolean.class);
    }

    public void reindexAll() {
        this.createResource().path("indexing").path("reindexAll").request().post(null, String.class);
    }

    public void reindexProject(Long projectId) {
        this.createResource().path("indexing").path("reindexProject").path(projectId.toString()).request().post(null, String.class);
        this.getProjectIndexingProgress(projectId).waitForCompletion();
    }

    public Long makeReindexRequest(ReindexRequestType type, String query, SharedEntityType ... sharedEntityTypes) {
        WebTarget target = this.createResource().path("indexing").path("makeReindexRequest").queryParam("type", new Object[]{type.name()}).queryParam("query", new Object[]{query});
        for (SharedEntityType sharedEntityType : sharedEntityTypes) {
            target.queryParam("sharedEntityType", new Object[]{sharedEntityType.name()});
        }
        return (Long)target.request().get(Long.class);
    }

    public Long clearPendingReindexRequests() {
        return (Long)this.createResource().path("indexing").path("clearPendingReindexRequests").request().get(Long.class);
    }

    public void callPeriodicStats() {
        this.createResource().path("indexing").path("periodicStats").request().post(null, String.class);
    }

    public void startScheduledReindex() {
        this.createResource().path("indexing").path("scheduledReindex").path("start").request().post(null, String.class);
    }

    public void pauseScheduledReindex() {
        this.createResource().path("indexing").path("scheduledReindex").path("pause").request().post(null, String.class);
    }

    public void startIndexRepairService() {
        this.createResource().path("indexing").path("repairService").path("start").request().post(null, String.class);
    }

    public void pauseIndexRepairService() {
        this.createResource().path("indexing").path("repairService").path("pause").request().post(null, String.class);
    }

    private class DefaultIndexingProgress
    extends IndexingProgress {
        private DefaultIndexingProgress() {
        }

        @Override
        boolean isIndexing() {
            return IndexingControl.this.isIndexingInProgress();
        }

        @Override
        boolean isIndexingStarted() {
            return IndexingControl.this.checkIsIndexingStarted();
        }

        @Override
        public String getTaskId() {
            return null;
        }
    }

    public abstract class IndexingProgress {
        private final long TIMEOUT_MINUTES = 5L;
        private final long MILLIS_PER_CHUNK = 200L;
        private final long MAX_TIMEOUT_IN_CHUNKS = 1500L;
        private long interval = 0L;
        private long overallChunks = 0L;

        public void waitForCompletion() {
            this.pollUntilTrue(() -> !this.isIndexing());
        }

        public void waitForIndexingStarted() {
            this.pollUntilTrue(this::isIndexingStarted);
        }

        private void pollUntilTrue(Supplier<Boolean> condition) {
            while (!condition.get().booleanValue()) {
                try {
                    Thread.sleep(++this.interval * 200L);
                    this.overallChunks += this.interval;
                    if (this.overallChunks <= 1500L) continue;
                    throw new RuntimeException("Indexing timed out.");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public long getProgress() {
            throw new NotImplementedException("Not implemented");
        }

        abstract boolean isIndexing();

        abstract boolean isIndexingStarted();

        public abstract String getTaskId();
    }
}

