/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.util.List;
import javax.ws.rs.client.WebTarget;

public class IssuePickerControl
extends BackdoorControl<IssuePickerControl> {
    private final Function<WebTarget, WebTarget> apiFunction;

    public static IssuePickerControl version1(JIRAEnvironmentData environmentData) {
        return new IssuePickerControl(environmentData, (Function<WebTarget, WebTarget>)((Function)webResource -> webResource.path("rest").path("api").path("1.0").path("issues").path("picker")));
    }

    public static IssuePickerControl version2(JIRAEnvironmentData environmentData) {
        return new IssuePickerControl(environmentData, (Function<WebTarget, WebTarget>)((Function)target -> target.path("rest").path("api").path("2").path("issue").path("picker")));
    }

    private IssuePickerControl(JIRAEnvironmentData environmentData, Function<WebTarget, WebTarget> apiFunction) {
        super(environmentData);
        this.apiFunction = apiFunction;
    }

    public IssuePickerResult getIssuePickerResult(String query, String currentJQL, String currentIssueKey, String currentProjectId, Boolean showSubTasks, Boolean showSubTaskParent) {
        WebTarget target = ((WebTarget)this.apiFunction.apply((Object)this.resourceRoot(this.rootPath))).queryParam("query", new Object[]{this.emptyStringIfNull(query)}).queryParam("currentJQL", new Object[]{this.emptyStringIfNull(currentJQL)}).queryParam("currentIssueKey", new Object[]{this.emptyStringIfNull(currentIssueKey)}).queryParam("currentProjectId", new Object[]{this.emptyStringIfNull(currentProjectId)}).queryParam("showSubTasks", new Object[]{showSubTasks.toString()}).queryParam("showSubTaskParent", new Object[]{showSubTaskParent.toString()});
        return (IssuePickerResult)target.request().get(IssuePickerResult.class);
    }

    private String emptyStringIfNull(String currentJQL) {
        return (String)MoreObjects.firstNonNull((Object)currentJQL, (Object)"");
    }

    public static class IssuePickerIssue {
        @JsonProperty
        private String key;
        @JsonProperty
        private String keyHtml;
        @JsonProperty
        private String img;
        @JsonProperty
        private String summary;
        @JsonProperty
        private String summaryText;

        public String getKey() {
            return this.key;
        }

        public String getKeyHtml() {
            return this.keyHtml;
        }

        public String getImg() {
            return this.img;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getSummaryText() {
            return this.summaryText;
        }

        public String toString() {
            return "IssuePickerIssue{key='" + this.key + '\'' + ", keyHtml='" + this.keyHtml + '\'' + ", img='" + this.img + '\'' + ", summary='" + this.summary + '\'' + ", summaryText='" + this.summaryText + '\'' + '}';
        }
    }

    public static class IssueSection {
        @JsonProperty
        private String label;
        @JsonProperty
        private String sub;
        @JsonProperty
        private String id;
        @JsonProperty
        private String msg;
        @JsonProperty
        private List<IssuePickerIssue> issues;

        public String getLabel() {
            return this.label;
        }

        public String getSub() {
            return this.sub;
        }

        public String getId() {
            return this.id;
        }

        public String getMsg() {
            return this.msg;
        }

        public List<IssuePickerIssue> getIssues() {
            return this.issues;
        }

        public String toString() {
            return "IssueSection{label='" + this.label + '\'' + ", sub='" + this.sub + '\'' + ", id='" + this.id + '\'' + ", msg='" + this.msg + '\'' + ", issues=" + this.issues + '}';
        }
    }

    public static class IssuePickerResult {
        @JsonProperty
        private List<IssueSection> sections;

        public List<IssueSection> getSections() {
            return this.sections;
        }

        public String toString() {
            return "IssuePickerResult{sections=" + this.sections + '}';
        }
    }
}

