/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.ProjectControlExt;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.client.PermissionSchemesControl;
import com.atlassian.jira.testkit.client.UsersAndGroupsControl;
import org.apache.commons.lang3.RandomStringUtils;

public class ManagedPermissions {
    private final String groupName = ManagedPermissions.withRandomSuffix("test-group");
    private final UsersAndGroupsControl users;
    private final PermissionSchemesControl schemes;
    private final ProjectControlExt project;
    private final Long managedScheme;

    ManagedPermissions(UsersAndGroupsControl users, PermissionSchemesControl schemes, ProjectControlExt project, String userName) {
        this.users = users;
        this.schemes = schemes;
        this.project = project;
        String schemeName = ManagedPermissions.withRandomSuffix("test-scheme");
        this.managedScheme = schemes.createScheme(schemeName, "description for " + schemeName);
        this.addUserIfNotExists(userName);
        users.addGroup(this.groupName);
        users.addUserToGroup(userName, this.groupName);
    }

    private static String withRandomSuffix(String name) {
        return name + "-" + RandomStringUtils.randomAlphabetic((int)8);
    }

    private void addUserIfNotExists(String userName) {
        if (!this.users.userExists(userName)) {
            this.users.addUser(userName, userName, userName, userName + "@dev.null");
        }
    }

    public ManagedPermissions addUser(String userName) {
        this.users.addUserToGroup(userName, this.groupName);
        return this;
    }

    public ManagedPermissions forProject(String projectKey) {
        this.project.setPermissionScheme(this.project.getProjectId(projectKey), this.managedScheme);
        return this;
    }

    public ManagedPermissions add(ProjectPermissionKey permissionKey) {
        this.schemes.addGroupPermission(this.managedScheme, permissionKey, this.groupName);
        return this;
    }

    public ManagedPermissions remove(ProjectPermissionKey permissionKey) {
        this.schemes.removeGroupPermission(this.managedScheme.longValue(), permissionKey, this.groupName);
        return this;
    }
}

