/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.rest.v2.monitoring.AppMonitoringController;
import com.atlassian.jira.rest.v2.monitoring.IpdMonitoringController;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.TestAppMonitoringController;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.TestIpdMonitoringController;
import com.atlassian.util.profiling.MetricTag;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class ProfilingControl
extends BackdoorControl<ProfilingControl> {
    private final TestAppMonitoringController.AppMonitoringClient appMonitoringClient;
    private final TestIpdMonitoringController.IpdMonitoringClient ipdMonitoringClient;

    public ProfilingControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.appMonitoringClient = new TestAppMonitoringController.AppMonitoringClient(environmentData);
        this.ipdMonitoringClient = new TestIpdMonitoringController.IpdMonitoringClient(environmentData);
    }

    public boolean isJmxEnabled() {
        return (Boolean)this.jmxEnabled().request().get(Boolean.class);
    }

    public void enableJmx() {
        this.jmxEnabled().request().put(Entity.json(null), String.class);
    }

    public void disableJmx() {
        this.jmxEnabled().request().delete();
    }

    public boolean isAppMonitoringEnabled() {
        return ((AppMonitoringController.AppMonitoringRestEntity)this.appMonitoringClient.getAppMonitoringState().body).isEnabled();
    }

    public void enableAppMonitoring() {
        this.appMonitoringClient.setAppMonitoringState(true);
    }

    public void disableAppMonitoring() {
        this.appMonitoringClient.setAppMonitoringState(false);
    }

    public void enableIpdMonitoring() {
        this.ipdMonitoringClient.setIpdMonitoringState(true);
    }

    public void disableIpdMonitoring() {
        this.ipdMonitoringClient.setIpdMonitoringState(false);
    }

    public boolean isIpdMonitoringEnabled() {
        return ((IpdMonitoringController.IpdMonitoringRestEntity)this.ipdMonitoringClient.getIpdMonitoringState().body).isEnabled();
    }

    public void emitTimer(String name, MetricTag ... tags) {
        this.createResource().path("profiling").path("metrics").path("timers").path(name).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(Arrays.stream(tags).collect(Collectors.toMap(MetricTag::getKey, MetricTag::getValue))), String.class);
    }

    public Map<String, Object> getMBeanAttributes(String name, String ... includes) {
        WebTarget target = this.createResource().path("profiling/jmx/mbeans").path(name).path("attributes");
        for (String include : includes) {
            target = target.queryParam("include", new Object[]{include});
        }
        return (Map)target.request().get((GenericType)new GenericType<Map<String, Object>>(){});
    }

    private WebTarget jmxEnabled() {
        return this.createResource().path("profiling").path("jmx").path("enabled");
    }
}

