/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class QuicksearchControl
extends BackdoorControl<QuicksearchControl> {
    private static final GenericType<List<SearchResultGroup>> SEARCH_RESULT_LIST = new GenericType<List<SearchResultGroup>>(){};

    public QuicksearchControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public SearchResult search(String query) {
        List result = (List)this.createResource().path("productsearch").path("search").queryParam("q", new Object[]{query}).request(new String[]{"application/json"}).get(SEARCH_RESULT_LIST);
        return new SearchResult(result);
    }

    @Override
    protected WebTarget createResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("quicksearch").path("latest");
    }

    @JsonSerialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class SearchResultItem {
        public String title;
        public String subtitle;
        public String avatarUrl;
        public String url;
        public boolean favourite;

        public String toString() {
            return String.format("SearchResultItem[title=%s]", this.title);
        }
    }

    @JsonSerialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SearchResultGroup {
        public String id;
        public String name;
        public String viewAllTitle;
        public List<SearchResultItem> items;
    }

    public static class SearchResult {
        private final List<SearchResultGroup> groups;

        public SearchResult(List<SearchResultGroup> groups) {
            this.groups = groups;
        }

        public List<SearchResultGroup> allGroups() {
            return this.groups;
        }

        public List<SearchResultItem> projects() {
            return this.groups.stream().filter(group -> "Projects".equals(group.name)).flatMap(group -> group.items.stream()).collect(Collectors.toList());
        }

        public List<SearchResultItem> issues() {
            return this.groups.stream().filter(group -> "Issues".equals(group.name)).flatMap(group -> group.items.stream()).collect(Collectors.toList());
        }
    }
}

