/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.functest.framework.backdoor.SingleProductLicenseDetailsViewTO;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class SalLicenseControl
extends BackdoorControl<SalLicenseControl> {
    public SalLicenseControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public boolean addProductLicense(String productKey, License licenseKey) {
        return this.addProductLicense(productKey, licenseKey.getLicenseString());
    }

    public boolean addProductLicense(String productKey, String licenseKey) {
        try {
            this.createSalLicenseResource().path("products").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new ProductLicenseTO(productKey, licenseKey)), String.class);
            return true;
        }
        catch (Exception anyException) {
            return false;
        }
    }

    public Boolean deleteProductLicense(String productKey) {
        return (Boolean)this.createSalLicenseResource().path("products").path(productKey).request().delete(Boolean.class);
    }

    public List<String> getProductKeys() {
        return (List)this.createSalLicenseResource().path("products").request().get((GenericType)new GenericType<List<String>>(){});
    }

    public String getRawProductLicense(String productKey) {
        return (String)this.createSalLicenseResource().path("products").path(productKey).request().get(String.class);
    }

    public String getSupportEntitlementNumber() {
        return (String)this.createSalLicenseResource().path("sen").request().get(String.class);
    }

    public String getServerId() {
        return (String)this.createSalLicenseResource().path("serverid").request().get(String.class);
    }

    public String ping() {
        return (String)this.createSalLicenseResource().path("ping").request().get(String.class);
    }

    public Boolean hostAllowsCustomProducts() {
        return (Boolean)this.createSalLicenseResource().path("host").path("allowsCustomProducts").request().get(Boolean.class);
    }

    public Boolean hostAllowsMultipleLicenses() {
        return (Boolean)this.createSalLicenseResource().path("host").path("allowsMultipleLicenses").request().get(Boolean.class);
    }

    public SingleProductLicenseDetailsViewTO getProductLicenseDetails(String productKey) {
        return (SingleProductLicenseDetailsViewTO)this.createSalLicenseResource().path("product").path("details").path(productKey).request().get((GenericType)new GenericType<SingleProductLicenseDetailsViewTO>(){});
    }

    public List<MultiProductLicenseDetailsTO> getAllProductLicenses() {
        return (List)this.createSalLicenseResource().path("product").path("details").request().get((GenericType)new GenericType<List<MultiProductLicenseDetailsTO>>(){});
    }

    public MultiProductLicenseDetailsTO decodeLicenseDetails(String rawLicenseString) {
        return (MultiProductLicenseDetailsTO)this.createSalLicenseResource().path("product").path("details").path("decode").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new ProductLicenseTO(null, rawLicenseString)), MultiProductLicenseDetailsTO.class);
    }

    public MultiProductLicenseDetailsTO decodeLicenseDetails(License license) {
        return this.decodeLicenseDetails(license.getLicenseString());
    }

    public ValidationResultTO validateLicenseString(String productKey, License license, Locale locale) {
        return this.validateLicenseString(productKey, license.getLicenseString(), locale);
    }

    public ValidationResultTO validateLicenseString(String productKey, String rawLicenseString, Locale locale) {
        return (ValidationResultTO)this.createSalLicenseResource().path("product").path("validate").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new ProductLicenseTO(productKey, rawLicenseString, locale)), ValidationResultTO.class);
    }

    private WebTarget createSalLicenseResource() {
        return this.createResource().path("sal").path("license");
    }

    public static class ValidationResultTO {
        @JsonProperty
        protected Set<String> errorMessages;
        @JsonProperty
        protected Set<String> warningMessages;

        public ValidationResultTO() {
            this.errorMessages = Sets.newHashSet();
            this.warningMessages = Sets.newHashSet();
        }

        public ValidationResultTO(Iterable<String> errorMessages, Iterable<String> warningMessages) {
            this.errorMessages = ImmutableSet.copyOf(errorMessages);
            this.warningMessages = ImmutableSet.copyOf(warningMessages);
        }

        public boolean isValid() {
            return this.errorMessages.isEmpty();
        }

        public boolean hasErrors() {
            return !this.errorMessages.isEmpty();
        }

        public boolean hasWarnings() {
            return !this.warningMessages.isEmpty();
        }

        public Set<String> getErrorMessages() {
            return this.errorMessages;
        }

        public Set<String> getWarningMessages() {
            return this.warningMessages;
        }

        public String toString() {
            return "ValidationResultTO{isValid=" + this.isValid() + ", hasErrors=" + this.hasErrors() + ", hasWarnings=" + this.hasWarnings() + ", errorMessages=" + this.errorMessages + ", warningMessages=" + this.warningMessages + '}';
        }
    }

    public static class BaseLicenseDetailsTO {
        @JsonProperty
        public boolean isEvaluationLicense;
        @JsonProperty
        public String licenseTypeName;
        @JsonProperty
        public String organisationName;
        @JsonProperty
        public String supportEntitlementNumber;
        @JsonProperty
        public String description;
        @JsonProperty
        public String serverId;
        @JsonProperty
        public boolean isPerpetualLicense;
        @JsonProperty
        public Date licenseExpiryDate;
        @JsonProperty
        public Date maintenanceExpiryDate;
        @JsonProperty
        public boolean isDataCenter;
        @JsonProperty
        public boolean isEnterpriseLicensingAgreement;
    }

    public static class ProductLicenseTO {
        @JsonProperty
        public String licenseKey;
        @JsonProperty
        public String productKey;
        @JsonProperty
        public boolean isUnlimitedNumberOfUsers;
        @JsonProperty
        public int numberOfUsers;
        @JsonProperty
        public String productDisplayName;
        @JsonProperty
        Locale locale;

        public ProductLicenseTO() {
        }

        public ProductLicenseTO(String licenseKey) {
            this.licenseKey = licenseKey;
        }

        public ProductLicenseTO(String productKey, String licenseKey) {
            this.productKey = productKey;
            this.licenseKey = licenseKey;
        }

        public ProductLicenseTO(String productKey, String licenseKey, Locale locale) {
            this.productKey = productKey;
            this.licenseKey = licenseKey;
            this.locale = locale;
        }
    }

    public static class MultiProductLicenseDetailsTO
    extends BaseLicenseDetailsTO {
        @JsonProperty
        public List<ProductLicenseTO> productLicenses;

        @Nullable
        public ProductLicenseTO getProductByKey(String productKey) {
            for (ProductLicenseTO productLicense : this.productLicenses) {
                if (!productLicense.productKey.equals(productKey)) continue;
                return productLicense;
            }
            return null;
        }
    }
}

