/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.changehistory;

import com.atlassian.jira.functest.framework.changehistory.ChangeHistorySet;

public class ChangeHistoryField {
    private final ChangeHistorySet set;
    private final String fieldName;
    private final String oldValue;
    private final String newValue;

    public ChangeHistoryField(ChangeHistorySet set, String fieldName, String oldValue, String newValue) {
        this.set = set;
        this.fieldName = ChangeHistoryField.canonical(fieldName);
        this.oldValue = ChangeHistoryField.canonical(oldValue);
        this.newValue = ChangeHistoryField.canonical(newValue);
    }

    static String canonical(String s) {
        return s == null ? "" : s.trim();
    }

    public ChangeHistorySet getEntry() {
        return this.set;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeHistoryField that = (ChangeHistoryField)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null);
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t'");
        sb.append(this.fieldName);
        sb.append("' ");
        sb.append("o: '");
        sb.append(this.oldValue);
        sb.append("'  ");
        sb.append("n: '");
        sb.append(this.newValue);
        sb.append("'");
        return sb.toString();
    }
}

