/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.dump.ArtifactDumper;
import com.atlassian.jira.functest.framework.dump.DumpDataProvider;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.meterware.httpunit.CurrentHttpInformation;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.ClientErrorException;
import org.junit.runner.Description;

public class TestCaseDumpKit {
    public static void dumpTestInformation(DumpDataProvider dataProvider, Date when, Throwable thrownException, boolean dumpHtml) {
        FuncTestLoggerImpl log = new FuncTestLoggerImpl();
        log.log((Object)"\n______ TEST FAILURE ______ \n");
        log.log(thrownException);
        CurrentHttpInformation.Info httpInfo = CurrentHttpInformation.getInfo();
        if (httpInfo != null) {
            log.log((Object)("URL              : " + httpInfo.getUrl()));
            log.log((Object)("HTTP METHOD      : " + httpInfo.getRequestMethod()));
            log.log((Object)("HTTP SC          : " + httpInfo.getStatusCode()));
            log.log((Object)("HTTP MSG         : " + httpInfo.getStatusMessage()));
            TestCaseDumpKit.dumpHeaders(log, "Request", httpInfo.getRequestHeaders());
            TestCaseDumpKit.dumpHeaders(log, "Response", httpInfo.getResponseHeaders());
        }
        if (dumpHtml) {
            new ArtifactDumper(dataProvider, thrownException, when, (FuncTestLogger)log);
        }
    }

    private static void dumpHeaders(FuncTestLoggerImpl log, String typeOfHeaders, Map<String, String[]> headers) {
        log.log((Object)("" + typeOfHeaders + " Headers : "));
        log.log((Object)"________________");
        for (String headerName : headers.keySet()) {
            String[] values;
            StringBuilder sb = new StringBuilder();
            for (String value : values = headers.get(headerName)) {
                sb.append("   ").append(headerName).append(" :").append(" ").append(value);
            }
            log.log((Object)sb);
        }
    }

    private static void dumpBody(FuncTestLoggerImpl log, String responseText) {
        log.log((Object)"Last Successful Response Body : ");
        log.log((Object)"________________");
        log.log((Object)responseText.trim());
    }

    public static void dumpRestTestInformation(ClientErrorException e, Description description) {
        FuncTestLoggerImpl log = new FuncTestLoggerImpl();
        log.log((Object)"\n______ TEST FAILURE ______ \n");
        try {
            log.log((Object)("HTTP SC            : " + e.getResponse().getStatus()));
            log.log((Object)("HTTP MSG           : " + (String)e.getResponse().readEntity(String.class)));
        }
        catch (RuntimeException runtimeException) {
            log.log((Object)("CANNOT GET DETAILS : " + runtimeException.getMessage()));
        }
        log.log((Throwable)e);
    }
}

