/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.email;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.jayway.awaitility.Awaitility;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matchers;

public class OutgoingMailHelper {
    private final Backdoor backdoor;

    @Inject
    public OutgoingMailHelper(Backdoor backdoor) {
        this.backdoor = backdoor;
    }

    public List<MimeMessage> filterMessages(Collection<MimeMessage> messages, Predicate<MimeMessage> predicate) {
        return (List)messages.stream().filter(predicate).collect(CollectorsUtil.toImmutableList());
    }

    public List<MimeMessage> filterMessagesForRecipient(Collection<MimeMessage> messages, String recipient) {
        return this.filterMessages(messages, message -> {
            try {
                return Arrays.asList(message.getHeader("To")).contains(recipient);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Collection<MimeMessage> flushMailQueueAndWait(int emailCount) {
        return this.flushMailQueueAndWait(emailCount, 5000);
    }

    public Collection<MimeMessage> flushMailQueueAndWait(long emailCount, int waitPeriodMillis) {
        if (!this.backdoor.getTestkit().mailServers().isSmtpConfigured()) {
            throw new RuntimeException("Smtp is not configured properly. Check the existence of @Before annotation in the test and presence of backdoor.restoreData().");
        }
        this.flushMailQueue();
        Awaitility.await().atMost((long)waitPeriodMillis, TimeUnit.MILLISECONDS).until(() -> this.backdoor.outgoingMailControl().countMails(), Matchers.equalTo((Object)emailCount));
        return (Collection)this.backdoor.outgoingMailControl().getMails().collect(CollectorsUtil.toImmutableList());
    }

    private void flushMailQueue() {
        this.backdoor.mailServers().flushMailQueue();
    }

    public void clearOutgoingMailQueue() {
        this.backdoor.outgoingMailControl().clearMessages();
    }

    public String getPreviewUrl(MimeMessage message) {
        try {
            return this.backdoor.outgoingMailControl().getMessagePreviewURI(message);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<MimeMessage> getMessagesForAddress(Collection<MimeMessage> messages, String toAddress) throws MessagingException {
        return messages.stream().filter(message -> toAddress.equals(this.getRecipients((MimeMessage)message, Message.RecipientType.TO)[0].toString())).collect(Collectors.toList());
    }

    public MimeMessage getMessageForAddress(Collection<MimeMessage> messages, String toAddress) throws MessagingException {
        return this.getMessagesForAddress(messages, toAddress).stream().findFirst().orElse(null);
    }

    private Address[] getRecipients(MimeMessage message, Message.RecipientType recipientType) {
        try {
            return message.getRecipients(recipientType);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

