/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigationImpl;
import com.atlassian.jira.util.ProgressPageControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.EnumSet;
import net.sourceforge.jwebunit.WebTester;

public class BulkChangeWizardImpl
implements BulkChangeWizard {
    private final WebTester tester;
    private final IssueNavigation issueNavigation;
    protected static final String BULK_EDIT_KEY = "10000_1_";
    protected static final String TARGET_PROJECT_ID = "10000_1_pid";
    protected static final String ISSUE_TYPE_SELECT = "10000_1_issuetype";
    protected static final String TARGET_PROJECT_ID_TEMPLATE = "10000_%d_pid";
    private BulkChangeWizard.WizardState state = BulkChangeWizard.WizardState.SELECT_ISSUES;
    private BulkChangeWizard.BulkOperations operation = null;

    public BulkChangeWizardImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.issueNavigation = new IssueNavigationImpl(tester, environmentData);
    }

    @Override
    public BulkChangeWizard selectAllIssues() {
        this.validateState(BulkChangeWizard.WizardState.SELECT_ISSUES);
        this.selectAllIssueCheckboxes();
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.CHOOSE_OPERATION;
        return this;
    }

    @Override
    public BulkChangeWizard chooseOperation(BulkChangeWizard.BulkOperations operation) {
        this.validateState(BulkChangeWizard.WizardState.CHOOSE_OPERATION);
        this.chooseOperationRadioButton(operation);
        this.clickOnNext();
        this.operation = operation;
        if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.MOVE.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS;
        } else if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.EDIT.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        } else if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.DELETE.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.CONFIRMATION;
        } else if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.ARCHIVE.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.CONFIRMATION;
        }
        return this;
    }

    @Override
    public BulkChangeWizard chooseWorkflowTransition(BulkChangeWizard.BulkOperations workflowTransition) {
        this.validateState(BulkChangeWizard.WizardState.CHOOSE_OPERATION);
        this.chooseCustomRadioButton("wftransition", workflowTransition.getRadioValue());
        this.clickOnNext();
        this.operation = workflowTransition;
        return this;
    }

    @Override
    public BulkChangeWizard chooseTargetContextForAll(String projectName) {
        return this.chooseTargetContextForAll(projectName, null);
    }

    @Override
    public BulkChangeWizard chooseTargetContextForAll(String projectName, String issueType) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS);
        this.checkSameTargetForAllCheckbox();
        this.selectFirstTargetProject(projectName);
        if (issueType != null && !issueType.isEmpty()) {
            this.selectIssueType(issueType);
        }
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        return this;
    }

    @Override
    public BulkChangeWizard chooseTargetContextForEach(int numContextsToSelect, String projectName) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS);
        this.selectEachTargetProject(numContextsToSelect, projectName);
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        return this;
    }

    @Override
    public BulkChangeWizard setFieldValue(String fieldName, String value) {
        return this.setFieldValue(BulkChangeWizard.InputTypes.TEXT, fieldName, value);
    }

    @Override
    public BulkChangeWizard setFieldValue(BulkChangeWizard.InputTypes inputType, String fieldName, String value) {
        this.validateState(BulkChangeWizard.WizardState.SET_FIELDS);
        switch (inputType) {
            case SELECT: {
                this.setSelectElement(fieldName, value);
                break;
            }
            default: {
                this.setTextElement(fieldName, value);
            }
        }
        return this;
    }

    @Override
    public BulkChangeWizard checkRetainForField(String fieldName) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.WizardState.SET_FIELDS);
        this.checkCheckbox("retain_" + fieldName);
        return this;
    }

    @Override
    public BulkChangeWizard checkActionForField(String fieldName) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.EDIT, BulkChangeWizard.WizardState.SET_FIELDS);
        this.checkCheckbox("actions", fieldName);
        return this;
    }

    @Override
    public BulkChangeWizard finaliseFields() {
        this.validateState(BulkChangeWizard.WizardState.SET_FIELDS);
        this.clickOnNext();
        if ((this.operation == BulkChangeWizard.BulkOperationsImpl.MOVE || this.operation == BulkChangeWizard.BulkOperationsImpl.EDIT) && this.pageContainsText("Step 4 of 4: Confirmation")) {
            this.state = BulkChangeWizard.WizardState.CONFIRMATION;
        }
        return this;
    }

    @Override
    public BulkChangeWizard complete() {
        this.validateState(BulkChangeWizard.WizardState.CONFIRMATION);
        if (this.operation == BulkChangeWizard.BulkOperationsImpl.MOVE) {
            this.clickOnNext();
        } else if (this.operation == BulkChangeWizard.BulkOperationsImpl.DELETE || this.operation == BulkChangeWizard.BulkOperationsImpl.ARCHIVE || this.operation == BulkChangeWizard.BulkOperationsImpl.EDIT) {
            this.clickOnConfirm();
        }
        this.state = BulkChangeWizard.WizardState.COMPLETE;
        return this;
    }

    @Override
    public BulkChangeWizard waitForBulkChangeCompletion() {
        this.validateState(BulkChangeWizard.WizardState.COMPLETE);
        this.tester.assertTextPresent("Bulk Operation Progress");
        ProgressPageControl.waitAndReload(this.tester, "bulkoperationprogressform", "Refresh", "Acknowledge");
        return this;
    }

    @Override
    public BulkChangeWizard revertTo(BulkChangeWizard.WizardState state) {
        if (this.state.getStage() <= state.getStage()) {
            throw new IllegalStateException(String.format("Cannot revert from state: %s to state: %s: target state does not precede the current state.", new Object[]{this.state, state}));
        }
        switch (state) {
            case CHOOSE_TARGET_CONTEXTS: {
                if (this.operation.equals(BulkChangeWizard.BulkOperationsImpl.MOVE)) break;
                throw new IllegalStateException(this.illegalStateForOperation(state, this.operation));
            }
            case SET_FIELDS: {
                if (!EnumSet.of(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.BulkOperationsImpl.DELETE).contains(this.operation)) break;
                throw new IllegalStateException(this.illegalStateForOperation(state, this.operation));
            }
            case SELECT_ISSUES: 
            case CHOOSE_OPERATION: {
                this.operation = null;
                break;
            }
            case COMPLETE: 
            case CONFIRMATION: {
                throw new IllegalStateException(String.format("Cannot revert to state: %s.", new Object[]{state}));
            }
        }
        this.clickOnLinkWithText(state.getLinkText());
        this.state = state;
        return this;
    }

    @Override
    public BulkChangeWizard cancel() {
        this.clickOnLinkId("cancel");
        this.state = BulkChangeWizard.WizardState.COMPLETE;
        return this;
    }

    private String illegalStateForOperation(BulkChangeWizard.WizardState state, BulkChangeWizard.BulkOperations operation) {
        return String.format("Cannot revert to: %s: Operation %s does not this state.", new Object[]{state, operation});
    }

    private void validateState(BulkChangeWizard.WizardState expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Wizard is in invalid state. Expected state: " + (Object)((Object)expectedState) + "; actual state: " + this.state.toString());
        }
    }

    private void validateState(BulkChangeWizard.BulkOperations expectedOperation, BulkChangeWizard.WizardState expectedState) {
        if (this.operation != expectedOperation) {
            throw new IllegalStateException("Wizard is in invalid state. Expected operation: " + expectedOperation + "; actual operation: " + expectedOperation.toString());
        }
        this.validateState(expectedState);
    }

    @Override
    public BulkChangeWizard.WizardState getState() {
        return this.state;
    }

    protected void clickOnNext() {
        this.tester.submit("Next");
    }

    protected void clickOnConfirm() {
        this.tester.submit("Confirm");
    }

    protected void selectAllIssueCheckboxes() {
        String[] paramNames;
        this.tester.setWorkingForm("bulkedit");
        for (String paramName : paramNames = this.tester.getDialog().getForm().getParameterNames()) {
            if (!paramName.startsWith("bulkedit_")) continue;
            this.tester.checkCheckbox(paramName);
        }
    }

    protected void chooseOperationRadioButton(BulkChangeWizard.BulkOperations operation) {
        this.setTextElement("operation", operation.getRadioValue());
    }

    protected void chooseCustomRadioButton(String radiogroupName, String radiobuttonValue) {
        this.setTextElement(radiogroupName, radiobuttonValue);
    }

    protected void selectFirstTargetProject(String projectName) {
        this.issueNavigation.selectProject(projectName, TARGET_PROJECT_ID);
    }

    protected void selectIssueType(String issueType) {
        this.issueNavigation.selectIssueType(issueType, ISSUE_TYPE_SELECT);
    }

    protected void selectEachTargetProject(int numContextsToSelect, String projectName) {
        for (int i = 1; i <= numContextsToSelect; ++i) {
            this.issueNavigation.selectProject(projectName, String.format(TARGET_PROJECT_ID_TEMPLATE, i));
        }
    }

    protected void checkSameTargetForAllCheckbox() {
        this.tester.checkCheckbox("sameAsBulkEditBean", BULK_EDIT_KEY);
    }

    protected void setTextElement(String fieldName, String value) {
        this.tester.setFormElement(fieldName, value);
    }

    protected void setSelectElement(String fieldName, String value) {
        this.tester.setFormElement(fieldName, value);
    }

    protected void checkCheckbox(String fieldName) {
        this.tester.checkCheckbox(fieldName);
    }

    protected void checkCheckbox(String checkboxName, String value) {
        this.tester.checkCheckbox(checkboxName, value);
    }

    protected boolean pageContainsText(String text) {
        return this.tester.getDialog().getResponseText().matches("(?s).*" + text.replace(" ", "\\s*") + ".*");
    }

    protected void clickOnLinkId(String id) {
        this.tester.clickLink(id);
    }

    protected void clickOnLinkWithText(String linkText) {
        this.tester.clickLinkWithText(linkText);
    }
}

