/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.admin.Subtasks;
import com.atlassian.jira.functest.framework.admin.SubtasksImpl;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.admin.TimeTrackingImpl;
import com.atlassian.jira.functest.framework.assertions.AssertionsImpl;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigationImpl;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultAttachmentManagement;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultAttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultFileAttachmentsList;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultImageAttachmentsGallery;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.w3c.dom.Node;

public class IssueNavigationImpl
implements IssueNavigation {
    private static final String WORKFLOW_ACTION_RESOLVE_ISSUE = "action_id_5";
    private static final String WORKFLOW_ACTION_REOPEN_ISSUE = "action_id_3";
    private static final String WORKFLOW_ACTION_CLOSE_ISSUE = "action_id_2";
    private final Backdoor backdoor;
    private final ViewIssuePage viewIssuePage;
    private final FuncTestLogger logger;
    private final com.atlassian.jira.functest.framework.assertions.Assertions assertions;
    private final LocatorFactory locators;
    private final TimeTracking timeTracking;
    private final IssueNavigatorNavigation issueNavigatorNavigation;
    private final Subtasks subtasks;
    private final WebTester tester;
    private final HtmlPage htmlPage;
    private final WorkflowUtil workflowUtil;
    private Supplier<List<IssueTypeControl.IssueType>> issueTypes = Suppliers.memoize((Supplier)new Supplier<List<IssueTypeControl.IssueType>>(){

        public List<IssueTypeControl.IssueType> get() {
            return IssueNavigationImpl.this.backdoor.issueType().getIssueTypes();
        }
    });
    private Supplier<List<Project>> projects = Suppliers.memoize((Supplier)new Supplier<List<Project>>(){

        public List<Project> get() {
            return IssueNavigationImpl.this.backdoor.project().getProjects();
        }
    });

    @Inject
    public IssueNavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.htmlPage = new HtmlPage(tester);
        this.backdoor = new Backdoor(environmentData);
        this.locators = new LocatorFactoryImpl(tester);
        this.viewIssuePage = new ViewIssuePage(tester, this.locators);
        this.logger = new FuncTestLoggerImpl(2);
        this.timeTracking = new TimeTrackingImpl(tester, environmentData);
        this.subtasks = new SubtasksImpl(tester, environmentData);
        this.issueNavigatorNavigation = new IssueNavigatorNavigationImpl(tester, environmentData);
        this.workflowUtil = new WorkflowUtil(tester, environmentData, this.locators);
        this.assertions = new AssertionsImpl(tester, environmentData, null, this.locators, this.backdoor);
    }

    @Override
    public ViewIssuePage viewIssue(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey);
        return this.viewIssuePage;
    }

    @Override
    public void viewPrintable(String issueKey) {
        this.tester.gotoPage("/si/jira.issueviews:issue-html/" + issueKey + "/" + issueKey + ".html");
    }

    @Override
    public void viewXml(String issueKey) {
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml");
    }

    @Override
    public void gotoEditIssue(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey);
        this.tester.clickLink("edit-issue");
    }

    @Override
    public void gotoEditIssue(long issueId) {
        this.tester.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
    }

    @Override
    public void deleteIssue(String issueKey) {
        this.viewIssue(issueKey);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
    }

    @Override
    public void gotoIssue(String issueKey) {
        if (issueKey == null) {
            throw new IllegalArgumentException("IssueKey should not be null.");
        }
        this.tester.beginAt("/browse/" + issueKey + "?showAll=true");
    }

    @Override
    public void gotoIssueChangeHistory(String issueKey) {
        if (issueKey == null) {
            throw new IllegalArgumentException("IssueKey should not be null.");
        }
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
    }

    @Override
    public void gotoIssueWorkLog(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
    }

    @Override
    public void gotoIssueComments(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
    }

    @Override
    public String createIssue(String projectName, String issueType, String summary) {
        this.goToCreateIssueForm(projectName, issueType);
        return this.createIssueDetails(summary, null);
    }

    @Override
    public String createIssue(String projectName, String issueType, String summary, Map<String, String[]> params) {
        this.goToCreateIssueForm(projectName, issueType);
        return this.createIssueDetails(summary, null, params);
    }

    @Override
    public String createSubTask(String parentIssueKey, String subTaskType, String subTaskSummary, String subTaskDescription) {
        return this.createSubTask(parentIssueKey, subTaskType, subTaskSummary, subTaskDescription, null);
    }

    @Override
    public String createSubTask(String parentIssueKey, String subTaskType, String subTaskSummary, String subTaskDescription, String originalEstimate) {
        this.createSubTaskStep1(parentIssueKey, subTaskType);
        if (originalEstimate != null) {
            this.tester.setFormElement("timetracking", "2h");
        }
        return this.createIssueDetails(subTaskSummary, subTaskDescription);
    }

    private String createIssueDetails(String summary, String description) {
        this.tester.setFormElement("summary", summary);
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        this.tester.submit("Create");
        IdLocator idLocator = new IdLocator(this.tester, "key-val");
        String issueKey = this.getIssueKey(idLocator);
        if (issueKey == null) {
            CssLocator locator = new CssLocator(this.tester, "#cant-browse-warning");
            issueKey = this.getNoPermissionError(locator);
        }
        return issueKey;
    }

    private String getIssueKey(Locator keyLocator) {
        String issueKey = null;
        Node[] tds = keyLocator.getNodes();
        if (tds.length > 0) {
            issueKey = keyLocator.getRawText();
            Assertions.assertThat((String)issueKey).isNotNull();
        }
        return issueKey;
    }

    private String getNoPermissionError(Locator locator) {
        Node[] tds;
        Pattern compile = Pattern.compile("\\((.*-\\d+)\\)");
        for (Node td : tds = locator.getNodes()) {
            Matcher matcher;
            String text = locator.getText(td);
            if (text == null || !(matcher = compile.matcher(text)).find()) continue;
            return matcher.group(1);
        }
        Fail.fail((String)"Could not find issue key for newly created issue");
        return null;
    }

    private String createIssueDetails(String summary, String description, Map<String, String[]> params) {
        if (params == null) {
            return this.createIssueDetails(summary, description);
        }
        FormParameterUtil formParamHelper = new FormParameterUtil(this.tester, "issue-create", "Create");
        formParamHelper.setFormElement("summary", summary);
        if (description != null) {
            formParamHelper.setFormElement("description", description);
        }
        formParamHelper.setParameters(params);
        Node createdIssueNode = formParamHelper.submitForm();
        XPathLocator issueLocator = new XPathLocator(createdIssueNode, "//*[@id='key-val']");
        String issueKey = this.getIssueKey(issueLocator);
        if (issueKey == null) {
            CssLocator locator = new CssLocator(createdIssueNode, "#cant-browse-warning");
            issueKey = this.getNoPermissionError(locator);
        }
        return issueKey;
    }

    @Override
    public void goToCreateIssueForm(String projectName, String issueType) {
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        if (this.tester.getDialog().getElement("issuetype") != null) {
            if (projectName != null) {
                this.selectProject(projectName);
            }
            if (issueType != null) {
                this.selectIssueType(issueType);
            }
            this.tester.setWorkingForm("issue-create");
            this.tester.submit();
        }
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        if (issueType != null) {
            this.tester.assertTextPresent(issueType);
        }
    }

    @Override
    public void selectProject(String projectName) {
        this.selectProject(projectName, "pid");
    }

    @Override
    public void selectProject(String projectName, String projectFieldName) {
        for (Project p : (List)this.projects.get()) {
            if (!projectName.equals(p.name)) continue;
            this.tester.setFormElement(projectFieldName, p.id);
        }
    }

    @Override
    public void selectIssueType(String issueType) {
        this.selectIssueType(issueType, "issuetype");
    }

    @Override
    public void selectIssueType(String issueType, String issueTypeFieldId) {
        for (IssueTypeControl.IssueType i : (List)this.issueTypes.get()) {
            if (!issueType.equals(i.getName())) continue;
            this.tester.setFormElement(issueTypeFieldId, i.getId());
        }
    }

    @Override
    public void createSubTaskStep1(String issueKey, String task_type) {
        this.subtasks.enable();
        this.viewIssue(issueKey);
        this.tester.clickLink("create-subtask");
        this.tester.assertTextPresent("Create Sub-Task");
        if (this.tester.getDialog().getElement("issuetype") == null) {
            this.logger.log((Object)"Bypassing step 1 of sub task creation");
        } else {
            this.tester.setWorkingForm("subtask-create-start");
            this.selectIssueType(task_type);
            this.tester.submit("Create");
        }
        this.tester.assertElementPresent("subtask-create-details");
    }

    @Override
    public void setPriority(String issueKey, String priority) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.selectOption("priority", priority);
        this.tester.submit("Update");
    }

    @Override
    public void setSecurity(String issueKey, String security) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.selectOption("security", security);
        this.tester.submit("Update");
    }

    @Override
    public void setEnvironment(String issueKey, String environment) {
        this.setSingleIssueField(issueKey, "environment", environment);
    }

    @Override
    public void setDescription(String issueKey, String description) {
        this.setSingleIssueField(issueKey, "description", description);
    }

    @Override
    public void setFreeTextCustomField(String issueKey, String customFieldId, String text) {
        this.setSingleIssueField(issueKey, customFieldId, text);
    }

    private void setSingleIssueField(String issueKey, String formElementName, String value) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement(formElementName, value);
        this.tester.submit("Update");
    }

    @Override
    public void assignIssue(String issueKey, String comment, String userFullName) {
        this.viewIssue(issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", userFullName);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        this.tester.submit("Assign");
        this.tester.assertTextPresent(userFullName);
        if (comment != null) {
            this.tester.assertTextPresent(comment);
        }
    }

    @Override
    public void assignIssue(String issueKey, String userFullName, String comment, String commentLevel) {
        this.viewIssue(issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.setWorkingForm("assign-issue");
        this.tester.selectOption("assignee", userFullName);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
            if (commentLevel != null) {
                this.tester.selectOption("commentLevel", commentLevel);
            }
        }
        this.tester.submit("Assign");
    }

    @Override
    public void unassignIssue(String issueKey, String comment) {
        this.assignIssue(issueKey, comment, "Unassigned");
    }

    @Override
    public void unassignIssue(String issueKey, String comment, String commentLevel) {
        this.assignIssue(issueKey, "Unassigned", comment, commentLevel);
    }

    @Override
    public void resolveIssue(String issueKey, String resolution, String comment) {
        this.resolveIssue(issueKey, resolution, (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)comment));
    }

    @Override
    public void resolveIssue(String issueKey, String resolution, Map<String, String> fieldValues) {
        this.viewIssue(issueKey);
        this.workflowUtil.clickAction(WORKFLOW_ACTION_RESOLVE_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", resolution);
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            this.tester.setFormElement(entry.getKey(), entry.getValue());
        }
        this.tester.submit("Transition");
    }

    @Override
    public void closeIssue(String issueKey, String resolution, String comment) {
        this.viewIssue(issueKey);
        this.workflowUtil.clickAction(WORKFLOW_ACTION_CLOSE_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", resolution);
        this.tester.setFormElement("comment", comment);
        this.tester.submit("Transition");
    }

    @Override
    public void linkIssueWithComment(String currentIssueKey, String link, String destinationIssueKey, String comment, String commentLevel) {
        this.linkIssueWithComment(currentIssueKey, link, destinationIssueKey, comment, commentLevel, destinationIssueKey);
    }

    @Override
    public void linkIssueWithComment(String currentIssueKey, String link, String destinationIssueKey, String comment, String commentLevel, String expectedText) {
        this.logger.log((Object)"Link Issue: test linking an issue");
        StringBuilder url = new StringBuilder().append("/secure/LinkJiraIssue.jspa?atl_token=").append(this.htmlPage.getXsrfToken()).append("&id=").append(this.backdoor.issues().getIssue((String)currentIssueKey).id).append("&linkDesc=").append(link).append("&currentIssueKey=").append(currentIssueKey).append("&issueKeys=").append(destinationIssueKey);
        if (comment != null) {
            url.append("&comment=").append(comment).append("&commentLevel=").append(commentLevel);
        }
        this.tester.gotoPage(url.toString());
        this.tester.assertTextPresent(expectedText);
    }

    @Override
    public AttachmentsBlock attachments(String issueKey) {
        this.viewIssue(issueKey);
        return new DefaultAttachmentsBlock(this.tester, this.logger, new DefaultFileAttachmentsList(this.tester, this.logger), new DefaultImageAttachmentsGallery(this.tester, this.logger), new DefaultAttachmentManagement(this.tester, this.logger));
    }

    @Override
    public AttachmentsBlock attachments(String issueKey, AttachmentsBlock.ViewMode viewMode) {
        AttachmentsBlock attachments = this.attachments(issueKey);
        attachments.setViewMode(viewMode);
        return attachments;
    }

    @Override
    public void resolveIssue(String issueKey, String resolution, String comment, String originalEstimate, String remainingEstimate) {
        String originalEstimateFieldId = this.getOriginalEstimateFieldId();
        String remainingEstimateFieldId = this.getRemainingEstimateFieldId();
        this.viewIssue(issueKey);
        this.workflowUtil.clickAction(WORKFLOW_ACTION_RESOLVE_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", resolution);
        this.tester.setFormElement("comment", comment);
        if (originalEstimate != null) {
            this.tester.setFormElement(originalEstimateFieldId, originalEstimate);
        }
        if (remainingEstimate != null) {
            this.tester.setFormElement(remainingEstimateFieldId, remainingEstimate);
        }
        this.tester.submit("Transition");
    }

    @Override
    public void logWork(String issueKey, String timeLogged) {
        this.viewIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.submit("Log");
    }

    @Override
    public void logWork(String issueKey, String timeLogged, String newEstimate) {
        this.gotoIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.checkCheckbox("adjustEstimate", "new");
        this.tester.setFormElement("newEstimate", newEstimate);
        this.tester.submit("Log");
    }

    @Override
    public void logWorkWithComment(String issueKey, String timeLogged, String comment) {
        this.gotoIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.checkCheckbox("adjustEstimate", "new");
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        this.tester.submit("Log");
    }

    @Override
    public void reopenIssue(String issueKey) {
        this.viewIssue(issueKey);
        this.workflowUtil.clickAction(WORKFLOW_ACTION_REOPEN_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    @Override
    public void performIssueActionWithoutDetailsDialog(String issueKey, String actionName) {
        this.viewIssue(issueKey);
        this.tester.clickLinkWithText(actionName);
    }

    @Override
    public void unwatchIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (this.tester.getDialog().getResponseText().contains("watch-state-on")) {
            this.tester.clickLink("toggle-unwatch-issue");
        }
    }

    @Override
    public void watchIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (this.tester.getDialog().getResponseText().contains("watch-state-off")) {
            this.tester.clickLink("toggle-watch-issue");
        }
    }

    @Override
    public IssueNavigation addWatchers(String issueKey, String ... usernames) {
        this.viewIssue(issueKey);
        this.tester.clickLink("view-watcher-list");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", StringUtils.join((Object[])usernames, (String)","));
        this.tester.submit("add");
        for (String username : usernames) {
            this.assertions.assertNodeExists(this.locators.id("watcher_link_" + username));
        }
        return this;
    }

    @Override
    public void unvoteIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (!this.tester.getDialog().getResponseText().contains("vote-state-on")) {
            throw new RuntimeException("Could not unvote on issue");
        }
        this.tester.clickLink("toggle-unvote-issue");
    }

    @Override
    public void voteIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (!this.tester.getDialog().getResponseText().contains("vote-state-off")) {
            throw new RuntimeException("Could no vote on issue");
        }
        this.tester.clickLink("toggle-vote-issue");
    }

    @Override
    public void addComment(String issueKey, String comment) {
        this.addComment(issueKey, comment, null);
    }

    @Override
    public void addComment(String issueKey, String comment, String roleLevel) {
        this.viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", comment);
        if (roleLevel != null) {
            this.tester.selectOption("commentLevel", roleLevel);
        }
        this.tester.submit();
    }

    @Override
    public void setFixVersions(String issueKey, String ... fixVersions) {
        this.setIssueMultiSelectField(issueKey, "fixVersions", fixVersions);
    }

    @Override
    public void setAffectsVersions(String issueKey, String ... affectsVersions) {
        this.setIssueMultiSelectField(issueKey, "versions", affectsVersions);
    }

    @Override
    public void setComponents(String issueKey, String ... components) {
        this.setIssueMultiSelectField(issueKey, "components", components);
    }

    @Override
    public void setDueDate(String issueKey, String dateString) {
        this.setSingleIssueField(issueKey, "duedate", dateString);
    }

    @Override
    public void setIssueMultiSelectField(String issueKey, String selectName, String ... options) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        for (String option : options) {
            String value = this.tester.getDialog().getValueForOption(selectName, option);
            this.tester.checkCheckbox(selectName, value);
        }
        this.tester.submit("Update");
    }

    @Override
    public void setEstimates(String issueKey, String originalEstimate, String remainingEstimate) {
        String originalEstimateFieldId = this.getOriginalEstimateFieldId();
        String remainingEstimateFieldId = this.getRemainingEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementPresent(originalEstimateFieldId);
        this.tester.setFormElement(originalEstimateFieldId, originalEstimate);
        this.tester.assertFormElementPresent(remainingEstimateFieldId);
        this.tester.setFormElement(remainingEstimateFieldId, remainingEstimate);
        this.tester.submit();
    }

    @Override
    public void setOriginalEstimate(String issueKey, String newValue) {
        String estimateFieldId = this.getOriginalEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementPresent(estimateFieldId);
        this.tester.setFormElement(estimateFieldId, newValue);
        this.tester.submit();
    }

    @Override
    public void setRemainingEstimate(String issueKey, String newValue) {
        String remainingEstimateFieldId = this.getRemainingEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementPresent(remainingEstimateFieldId);
        this.tester.setFormElement(remainingEstimateFieldId, newValue);
        this.tester.submit();
    }

    @Override
    public IssueNavigation editLabels(int issueId) {
        this.tester.clickLink("edit-labels-" + issueId + "-labels");
        return this;
    }

    @Override
    public IssueNavigation editCustomLabels(int issueId, int customFieldId) {
        this.tester.clickLink("edit-labels-" + issueId + "-customfield_" + customFieldId);
        return this;
    }

    @Override
    public IssueNavigatorNavigation returnToSearch() {
        this.tester.gotoPage("/issues/?jql=");
        return this.issueNavigatorNavigation;
    }

    @Override
    public String getId(String issueKey) {
        this.gotoIssue(issueKey);
        String issueId = "";
        try {
            String text = this.tester.getDialog().getResponse().getText();
            String paramName = "ViewVoters!default.jspa?id=";
            int issueIdLocation = text.indexOf("ViewVoters!default.jspa?id=") + "ViewVoters!default.jspa?id=".length();
            issueId = text.substring(issueIdLocation, issueIdLocation + 5);
        }
        catch (IOException e) {
            this.logger.log((Object)("Unable to retrieve issue id" + e.getMessage()));
            Fail.fail((String)String.format("No issue id could be found using issue key:'%s'. IOException caught: '%s'", issueKey, e.getMessage()));
        }
        return issueId;
    }

    private String getOriginalEstimateFieldId() {
        if (this.timeTracking.isIn(TimeTracking.Mode.LEGACY)) {
            return "timetracking";
        }
        return "timetracking_originalestimate";
    }

    private String getRemainingEstimateFieldId() {
        if (this.timeTracking.isIn(TimeTracking.Mode.LEGACY)) {
            return "timetracking";
        }
        return "timetracking_remainingestimate";
    }
}

