/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentManagement;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Element;

public class DefaultAttachmentsBlock
implements AttachmentsBlock {
    private WebTester tester;
    private static final String ISSUE_KEY_ID = "key-val";
    private FuncTestLogger logger;
    private AttachmentManagement attachmentManagement;
    private static final String MANAGE_ATTACHMENTS_LINK_ID = "manage-attachment-link";
    private ImageAttachmentsGallery imageAttachmentsGallery;
    private FileAttachmentsList fileAttachmentsList;

    public DefaultAttachmentsBlock(WebTester tester, FuncTestLogger logger, FileAttachmentsList fileAttachmentsList, ImageAttachmentsGallery imageAttachmentsGallery, AttachmentManagement attachmentManagement) {
        this.tester = tester;
        this.logger = logger;
        this.attachmentManagement = attachmentManagement;
        this.imageAttachmentsGallery = imageAttachmentsGallery;
        this.fileAttachmentsList = fileAttachmentsList;
    }

    @Override
    public void sort(AttachmentsBlock.Sort.Key key, AttachmentsBlock.Sort.Direction direction) {
        this.tester.assertElementPresent(ISSUE_KEY_ID);
        IdLocator issueKeyLocator = new IdLocator(this.tester, ISSUE_KEY_ID);
        this.logger.log((Object)("Beginning to sort attachments by " + key + " in " + direction + " order, for the issue: " + issueKeyLocator.getText()));
        this.tester.clickLink(key.getLinkId());
        this.tester.clickLink(direction.getLinkId());
        this.logger.log((Object)("Finished sorting attachments by " + key + " in " + direction + " order, for the issue: " + issueKeyLocator.getText()));
    }

    @Override
    public AttachmentManagement manage() {
        this.tester.assertElementPresent(ISSUE_KEY_ID);
        this.tester.clickLink(MANAGE_ATTACHMENTS_LINK_ID);
        return this.attachmentManagement;
    }

    @Override
    public AttachmentsBlock.ViewMode getViewMode() {
        Element galleryLink = this.tester.getDialog().getElement(AttachmentsBlock.ViewMode.GALLERY.getLinkId());
        Element listLink = this.tester.getDialog().getElement(AttachmentsBlock.ViewMode.LIST.getLinkId());
        if (galleryLink.getAttribute("class").contains("aui-checked")) {
            return AttachmentsBlock.ViewMode.GALLERY;
        }
        if (listLink.getAttribute("class").contains("aui-checked")) {
            return AttachmentsBlock.ViewMode.LIST;
        }
        throw new IllegalStateException("Unable to find active view mode link");
    }

    @Override
    public void setViewMode(AttachmentsBlock.ViewMode viewMode) {
        this.tester.clickLink(viewMode.getLinkId());
    }

    @Override
    public ImageAttachmentsGallery gallery() {
        return this.imageAttachmentsGallery;
    }

    @Override
    public FileAttachmentsList list() {
        return this.fileAttachmentsList;
    }
}

