/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.IssueTableHasColumnCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public class ValueForRowAtColumnCondition
implements SearchResultsCondition {
    private final int row;
    private final String columnName;
    private final String expectedValue;
    private final IssueTableHasColumnCondition containsColumn;

    public ValueForRowAtColumnCondition(int row, String columnName, String expectedValue) {
        this.row = row;
        this.columnName = columnName;
        this.expectedValue = expectedValue;
        this.containsColumn = new IssueTableHasColumnCondition(columnName);
    }

    @Override
    public void assertCondition(WebTester tester) {
        Integer columnPosition;
        WebTable table = this.containsColumn.getIssueTable(tester);
        if (table == null) {
            Fail.fail((String)"Unable to find issue table");
        }
        if ((columnPosition = this.getColumnPosition(table)) == null) {
            Fail.fail((String)("Unable to find the column " + this.columnName + " on the issue table"));
        }
        Assertions.assertThat((String)this.textAt(table, this.row, columnPosition)).isEqualTo(this.expectedValue);
    }

    private Integer getColumnPosition(WebTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            String cellText = this.textAt(table, 0, i);
            if (!this.columnName.equals(cellText)) continue;
            return i;
        }
        return null;
    }

    private String textAt(WebTable table, int row, int column) {
        return StringUtils.trimToNull((String)table.getCellAsText(row, column));
    }
}

