/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.page;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewIssuePage {
    private final WebTester tester;
    private final LocatorFactory locators;

    @Inject
    public ViewIssuePage(WebTester tester, LocatorFactory locators) {
        this.tester = tester;
        this.locators = locators;
    }

    public String getAssignee() {
        return this.getFieldValue("assignee");
    }

    public String getAssigneeUsername() {
        return ViewIssuePage.getRelUsername(this.getFieldNode("assignee"));
    }

    public String getReporter() {
        return this.getFieldValue("reporter");
    }

    public String getReporterUsername() {
        return ViewIssuePage.getRelUsername(this.getFieldNode("reporter"));
    }

    public String getCreatorUserName() {
        String creatorAnchorId = "issuecreator_" + this.getIssueId();
        String creator = this.locators.id(creatorAnchorId).getText();
        if (creator.equals("")) {
            creator = ViewIssuePage.getRelUsername(this.locators.css("#issuecreateddetails-" + this.getIssueId()).getNode());
        }
        return creator;
    }

    public ViewIssuePage openTabWithId(String id) {
        if (id.equals(this.getActiveTabId())) {
            return this;
        }
        this.tester.clickLink("changehistory-tabpanel");
        return this;
    }

    public String getActiveTabId() {
        Element activeTab = (Element)this.locators.css("#issue-tabs li.active").getNode();
        return activeTab.getAttribute("id");
    }

    public String getIssueId() {
        String id = "";
        Node node = this.locators.id("key-val").getNode();
        if (node != null & node instanceof Element) {
            id = ((Element)node).getAttribute("rel");
        }
        return id;
    }

    public String getFieldValue(String fieldName) {
        String value = this.locators.id(fieldName + "-val").getText();
        return value == null ? null : value.trim();
    }

    public Node getFieldNode(String fieldName) {
        return this.locators.id(fieldName + "-val").getNode();
    }

    public static String getRelUsername(Node node) {
        List<String> usernames = ViewIssuePage.getRelUsernames(node);
        return usernames.size() == 1 ? usernames.get(0) : null;
    }

    public static List<String> getRelUsernames(Node node) {
        return ViewIssuePage.recurse(new ArrayList<String>(), node);
    }

    private static List<String> recurse(List<String> collector, Node node) {
        if (node instanceof Element) {
            String userName;
            boolean isElementAnUpgradedUserHoverLink;
            Element element = (Element)node;
            boolean bl = isElementAnUpgradedUserHoverLink = element.hasAttribute("class") && element.getAttribute("class").contains("user-hover-replaced");
            if (element.hasAttribute("rel") && !isElementAnUpgradedUserHoverLink && StringUtils.isNotBlank((CharSequence)(userName = element.getAttribute("rel").trim()))) {
                collector.add(userName);
            }
            NodeList kids = element.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                ViewIssuePage.recurse(collector, kids.item(i));
            }
        }
        return collector;
    }

    public String getCustomFieldValue(int customFieldId) {
        return this.getFieldValue("customfield_" + customFieldId);
    }

    public String getCustomFieldRelUsername(int customFieldId) {
        return ViewIssuePage.getRelUsername(this.getFieldNode("customfield_" + customFieldId));
    }

    public List<String> getCustomFieldRelUsernames(int customFieldId) {
        return ViewIssuePage.getRelUsernames(this.getFieldNode("customfield_" + customFieldId));
    }

    public boolean hasVoted() {
        String title = this.locators.id("vote-toggle").getText();
        if (title.equals("Remove vote for this issue")) {
            return true;
        }
        if (title.equals("Vote for this issue")) {
            return false;
        }
        throw new IllegalStateException("Unknown Vote title '" + title + "'");
    }

    public int getVoteCount() {
        return Integer.parseInt(this.locators.id("vote-data").getText());
    }

    public ViewIssuePage toggleVote() {
        this.tester.clickLink("vote-toggle");
        return this;
    }

    public boolean canVote() {
        return this.locators.id("vote-toggle").exists();
    }

    public boolean isWatching() {
        String title = this.locators.id("watching-toggle").getText();
        if (title.equals("Stop watching this issue")) {
            return true;
        }
        if (title.equals("Start watching this issue")) {
            return false;
        }
        throw new IllegalStateException("Unknown watch title '" + title + "'");
    }

    public int getWatcherCount() {
        return Integer.parseInt(this.locators.id("watcher-data").getText());
    }

    public ViewIssuePage toggleWatch() {
        this.tester.clickLink("watching-toggle");
        return this;
    }

    public boolean containsEditButton() {
        IdLocator locator = this.locators.id("edit-issue");
        return locator.getNodes().length > 0;
    }
}

