/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.filter;

import com.atlassian.jira.functest.framework.parser.SharedEntityItem;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FilterItem
implements Cloneable,
SharedEntityItem {
    private long id;
    private String name;
    private String description;
    private String author;
    private List<WebTestSharePermission> sharing;
    private boolean fav;
    private long subscriptions;
    private List<String> operations = new ArrayList<String>();
    private long favCount;

    @Deprecated
    public FilterItem(long id, String name, String description, String author, long issues, List<WebTestSharePermission> sharing, Boolean fav, long subscriptions, List<String> operations, long favCount) {
        this(id, name, description, author, sharing, fav, subscriptions, operations, favCount);
    }

    public FilterItem(long id, String name, String description, String author, List<WebTestSharePermission> sharing, Boolean fav, long subscriptions, List<String> operations, long favCount) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.author = author;
        this.sharing = sharing;
        this.fav = fav;
        this.subscriptions = subscriptions;
        if (operations != null) {
            this.operations = operations;
        }
        this.favCount = favCount;
    }

    public FilterItem(FilterItem copyFrom) {
        this(copyFrom.id, copyFrom.name, copyFrom.description, copyFrom.author, copyFrom.sharing, copyFrom.fav, copyFrom.subscriptions, copyFrom.operations, copyFrom.favCount);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Long getIssues() {
        return 0L;
    }

    @Override
    public List getSharing() {
        return this.sharing;
    }

    @Override
    public Boolean isFav() {
        return this.fav;
    }

    @Override
    public Long getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public List getOperations() {
        return this.operations;
    }

    @Override
    public Long getFavCount() {
        return this.favCount;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public FilterItem setName(String name) {
        this.name = name;
        return this;
    }

    public FilterItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public FilterItem setAuthor(String author) {
        this.author = author;
        return this;
    }

    @Deprecated
    public FilterItem setIssues(long issues) {
        return this;
    }

    public FilterItem setSharing(List sharing) {
        this.sharing = sharing;
        return this;
    }

    public FilterItem setFav(boolean fav) {
        this.fav = fav;
        return this;
    }

    public FilterItem setSubscriptions(long subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public FilterItem setOperations(List operations) {
        this.operations = operations;
        return this;
    }

    public FilterItem setNoOperations() {
        return this.setOperations(Collections.emptyList());
    }

    public FilterItem setFavCount(long favCount) {
        this.favCount = favCount;
        return this;
    }

    public FilterItem setNoFavCount() {
        return this.setFavCount(0L);
    }

    public FilterItem setNoAuthor() {
        return this.setAuthor(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterItem)) {
            return false;
        }
        FilterItem rhs = (FilterItem)obj;
        return new EqualsBuilder().append((Object)this.author, (Object)rhs.author).append((Object)this.description, (Object)rhs.description).append(this.fav, rhs.fav).append(this.favCount, rhs.favCount).append(this.id, rhs.id).append((Object)this.name, (Object)rhs.name).append(this.operations, rhs.operations).append(this.sharing, rhs.sharing).append(this.subscriptions, rhs.subscriptions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.id).append((Object)this.name).append((Object)this.description).append((Object)this.author).append(this.sharing).append(this.fav).append(this.subscriptions).append(this.operations).append(this.favCount).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("name", (Object)this.name).append("author", (Object)this.author).append("fav", this.fav).append("favCount", this.favCount).append("description", (Object)this.description).append("sharing", this.sharing).append("subscriptions", this.subscriptions).append("operations", this.operations).toString();
    }

    public FilterItem cloneFilter() {
        try {
            return (FilterItem)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private long id;
        private String name;
        private String owner;
        private boolean isFavourite = false;
        private int favouriteCount;
        private String description = "";
        private int subscriptionCount;
        private List<String> availableOperations;
        private List<WebTestSharePermission> sharePermissions;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String filterName) {
            this.name = filterName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder asFavourite() {
            this.isFavourite = true;
            return this;
        }

        public Builder favouriteCount(int favouriteCount) {
            this.favouriteCount = favouriteCount;
            return this;
        }

        public Builder sharedWith(List<WebTestSharePermission> sharePermissions) {
            this.sharePermissions = sharePermissions;
            return this;
        }

        @Deprecated
        public Builder issueCount(int issueCount) {
            return this;
        }

        public Builder subscriptionCount(int subscriptionCount) {
            this.subscriptionCount = subscriptionCount;
            return this;
        }

        public Builder availableOperations(List<String> availableOperations) {
            this.availableOperations = availableOperations;
            return this;
        }

        public FilterItem build() {
            return new FilterItem(this.id, this.name, this.description, this.owner, this.sharePermissions, this.isFavourite, this.subscriptionCount, this.availableOperations, this.favouriteCount);
        }
    }
}

