/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.ParentRunnerHacker;
import com.atlassian.jira.functest.framework.suite.RunnerChildList;
import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.atlassian.jira.functest.framework.suite.TransformableRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class TransformingParentRunner<T>
extends ParentRunner<T> {
    private final String name;
    private final ParentRunnerHacker<T> parentRunnerHacker;
    private final List<SuiteTransform> transforms = Lists.newArrayList();
    private final RunnerChildList<T> childList;
    private final List<T> children;

    public static List<Description> applyTransforms(Iterable<Description> input, Iterable<SuiteTransform> transforms) {
        Iterable answer = input;
        for (SuiteTransform transform : transforms) {
            answer = (Iterable)transform.apply(ImmutableList.copyOf(answer));
        }
        return Lists.newArrayList(answer);
    }

    public TransformingParentRunner(String name, ParentRunner<T> original, Iterable<SuiteTransform> transforms) throws InitializationError {
        super(original.getTestClass().getJavaClass());
        this.name = name;
        this.parentRunnerHacker = new ParentRunnerHacker<T>(original);
        Iterables.addAll(this.transforms, transforms);
        this.childList = new RunnerChildList<T>(original);
        this.children = this.filterChildren();
    }

    public TransformingParentRunner(ParentRunner<T> original, Iterable<SuiteTransform> transforms) throws InitializationError {
        this(null, original, transforms);
    }

    private List<Description> applyTransforms() {
        List<Description> answer = this.childList.descriptions();
        return TransformingParentRunner.applyTransforms(answer, this.transforms);
    }

    private List<T> filterChildren() throws InitializationError {
        List<T> filtered = this.childList.matchingChildren(this.applyTransforms());
        ArrayList answer = Lists.newArrayList();
        for (T child : filtered) {
            if (child instanceof ParentRunner) {
                ParentRunner childRunner = (ParentRunner)child;
                ParentRunner<?> wrapped = this.wrap(childRunner, this.transforms);
                answer.add(wrapped);
                continue;
            }
            answer.add(child);
        }
        return answer;
    }

    protected ParentRunner<?> wrap(ParentRunner<?> original, List<SuiteTransform> transforms) throws InitializationError {
        if (original instanceof TransformableRunner) {
            return ((TransformableRunner)original).withTransforms(transforms);
        }
        return new TransformingParentRunner(original, transforms);
    }

    protected List<T> getChildren() {
        return this.children;
    }

    protected Description describeChild(T child) {
        return this.parentRunnerHacker.describeChild(child);
    }

    protected void runChild(T child, RunNotifier notifier) {
        this.parentRunnerHacker.runChild(child, notifier);
    }

    public Description getDescription() {
        Description original = super.getDescription();
        if (original.getChildren().isEmpty()) {
            return Description.EMPTY;
        }
        return original;
    }

    protected String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }
}

