/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.upm;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.integrationtesting.ApplicationPropertiesImpl;
import com.atlassian.jira.functest.framework.upm.DefaultCredentials;
import com.atlassian.jira.functest.framework.upm.PluginStatus;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpmRestClient {
    public static final String CONTENT_TYPE_PLUGIN_JSON = "application/vnd.atl.plugins.plugin+json";
    private final String baseUrl;
    private final UsernamePasswordCredentials credentials;
    private final DefaultHttpClientFactory httpClientFactory;
    private final HttpClient httpClient;
    private static final Logger log = LoggerFactory.getLogger(UpmRestClient.class);

    public UpmRestClient(String baseUrl, UsernamePasswordCredentials credentials) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseurl");
        this.credentials = (UsernamePasswordCredentials)Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        int timeout = 120;
        httpClientOptions.setSocketTimeout(120, TimeUnit.SECONDS);
        httpClientOptions.setConnectionTimeout(120, TimeUnit.SECONDS);
        httpClientOptions.setRequestTimeout(120, TimeUnit.SECONDS);
        this.httpClientFactory = new DefaultHttpClientFactory((EventPublisher)new VoidEventPublisher(), (ApplicationProperties)new ApplicationPropertiesImpl(baseUrl), new ThreadLocalContextManager(){

            public Object getThreadLocalContext() {
                return null;
            }

            public void setThreadLocalContext(Object context) {
            }

            public void clearThreadLocalContext() {
            }
        });
        this.httpClient = this.httpClientFactory.create(httpClientOptions);
    }

    public static UpmRestClient withDefaultAdminCredentials(String baseUrl) {
        return new UpmRestClient(baseUrl, DefaultCredentials.getDefaultAdminCredentials());
    }

    public boolean isPluginEnabled(String pluginKey) {
        return this.getPluginStatus(pluginKey).isEnabled();
    }

    public boolean isPluginUserInstalled(String pluginKey) {
        return this.getPluginStatus(pluginKey).isUserInstalled();
    }

    public PluginStatus getPluginStatus(String pluginKey) {
        try {
            return (PluginStatus)this.requestPluginStatus(pluginKey).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Promise<PluginStatus> requestPluginStatus(final String pluginKey) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        Request.Builder builder = this.newRequest(this.upmPluginInformation(pluginKey));
        final Request request = (Request)builder.build();
        return builder.get().transform((ResponseTransformation)DefaultResponseTransformation.builder().ok(response -> {
            String entity = response.getEntity();
            try {
                JSONObject jsonObject = new JSONObject(entity);
                boolean enabled = jsonObject.getBoolean("enabled");
                boolean userInstalled = jsonObject.getBoolean("userInstalled");
                return new PluginStatus(pluginKey, jsonObject, enabled, userInstalled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Requesting details of plugin with key \"" + pluginKey + "\" returned " + response.getStatusCode() + ": " + entity, e);
            }
        }).notFound(response -> {
            throw new RuntimeException("Could not get details on plugin with key \"" + pluginKey + "\": plugin not installed (404).");
        }).serverError((Function)new Function<Response, PluginStatus>(){

            @Override
            @Nullable
            public PluginStatus apply(@Nullable Response response) {
                throw UpmRestClient.httpRuntimeError(response, pluginKey, request);
            }
        }).build());
    }

    public Promise<Option<PluginStatus>> requestPluginStatusOption(final String pluginKey) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        Request.Builder builder = this.newRequest(this.upmPluginInformation(pluginKey));
        final Request request = (Request)builder.build();
        return builder.get().transform((ResponseTransformation)DefaultResponseTransformation.builder().ok(response -> {
            String entity = response.getEntity();
            try {
                JSONObject jsonObject = new JSONObject(entity);
                boolean enabled = jsonObject.getBoolean("enabled");
                boolean userInstalled = jsonObject.getBoolean("userInstalled");
                return Option.some((Object)new PluginStatus(pluginKey, jsonObject, enabled, userInstalled));
            }
            catch (JSONException e) {
                log.error("Got response " + response.getStatusCode() + ": " + entity);
                throw new RuntimeException(e);
            }
        }).notFound(response -> Option.none()).serverError((Function)new Function<Response, Option<PluginStatus>>(){

            @Override
            @Nullable
            public Option<PluginStatus> apply(Response response) {
                throw UpmRestClient.httpRuntimeError(response, pluginKey, request);
            }
        }).build());
    }

    public ResponsePromise updatePlugin(String pluginKey, String json) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        try {
            return ((Request.Builder)((Request.Builder)this.newRequest(this.upmPluginInformation(pluginKey)).setContentType(CONTENT_TYPE_PLUGIN_JSON)).setEntity(json)).put();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Request.Builder newRequest(URI uri) {
        Header authenticateHeader = BasicScheme.authenticate((Credentials)this.credentials, (String)"UTF-8", (boolean)false);
        return this.httpClient.newRequest(uri).setHeader(authenticateHeader.getName(), authenticateHeader.getValue());
    }

    private URI upmPluginInformation(String pluginKey) {
        return URI.create(this.baseUrl + "/rest/plugins/1.0/" + pluginKey + "-key");
    }

    public void destroy() throws Exception {
        this.httpClientFactory.dispose(this.httpClient);
    }

    private static RuntimeException httpRuntimeError(@Nullable Response response, String pluginKey, @Nullable Request request) {
        String message = String.format("Unable to get status for plugin [%s]:%s\trequest: [%s]%s\tresponse: [%s]", pluginKey, System.lineSeparator(), UpmRestClient.print(request), System.lineSeparator(), UpmRestClient.print(response));
        return new RuntimeException(message);
    }

    private static String print(@Nullable Request req) {
        if (req == null) {
            return "null";
        }
        return String.format("request { method: %s, uri: %s, contentType: %s, accept: %s , entity : %s }", req.getMethod(), req.getUri(), req.getContentType(), req.getAccept(), req.getEntity());
    }

    private static String print(@Nullable Response res) {
        if (res == null) {
            return "null";
        }
        return String.format("response { statusCode: %s, entity: %s, contentType: %s, text: %s }", res.getStatusCode(), res.getEntity(), res.getContentType(), res.getStatusText());
    }

    class VoidEventPublisher
    implements EventPublisher {
        VoidEventPublisher() {
        }

        public void publish(Object o) {
        }

        public void register(Object o) {
        }

        public void unregister(Object o) {
        }

        public void unregisterAll() {
        }
    }
}

