/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;

public class AsynchronousTasks {
    private final WebTester tester;

    public AsynchronousTasks(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        this(tester, environmentData);
    }

    @Inject
    public AsynchronousTasks(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
    }

    public void waitForSuccessfulCompletion(long sleepTime, int retryCount, String operationName) {
        for (int i = 0; i < retryCount; ++i) {
            if (this.tester.getDialog().hasSubmitButton("Refresh")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().hasSubmitButton("Acknowledge")) {
                    this.tester.submit("Acknowledge");
                    return;
                }
                Fail.fail((String)"Unexpected button on progress screen.");
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Fail.fail((String)(operationName + " operation did not complete after " + (double)(sleepTime * (long)retryCount) / 1000.0 + " sec."));
    }
}

