/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.dom;

import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.meterware.httpunit.HTMLPage;
import com.meterware.httpunit.WebResponse;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.WeakHashMap;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SneakyDomExtractor {
    private static final WeakHashMap<WebResponse, Document> preparsedDOMObjects = new WeakHashMap();

    public static Document getDOM(WebTester tester) {
        HttpUnitDialog dialog = tester.getDialog();
        WebResponse webResponse = dialog == null ? null : dialog.getResponse();
        Document document = preparsedDOMObjects.get(webResponse);
        if (document == null && webResponse != null) {
            document = SneakyDomExtractor.getDOMViaSneakyReflection(webResponse);
            document = SneakyDomExtractor.wrapDocument(document);
            document = (Document)DomKit.copyDOM(document, true);
            preparsedDOMObjects.put(webResponse, document);
        }
        return document;
    }

    private static Document getDOMViaSneakyReflection(WebResponse webResponse) {
        Document doc;
        try {
            Method getReceivedPage = WebResponse.class.getDeclaredMethod("getReceivedPage", new Class[0]);
            getReceivedPage.setAccessible(true);
            HTMLPage htmlPage = (HTMLPage)getReceivedPage.invoke((Object)webResponse, new Object[0]);
            Method getOriginalDOM = htmlPage.getClass().getSuperclass().getDeclaredMethod("getOriginalDOM", new Class[0]);
            getOriginalDOM.setAccessible(true);
            Node node = (Node)getOriginalDOM.invoke((Object)htmlPage, new Object[0]);
            doc = (Document)node;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return doc;
    }

    private static Document wrapDocument(Document originalDocument) {
        if (originalDocument.getClass().getName().indexOf("org.apache.html.dom") == -1) {
            // empty if block
        }
        SneakyInvocationHandler handler = new SneakyInvocationHandler(originalDocument);
        return (Document)Proxy.newProxyInstance(Document.class.getClassLoader(), new Class[]{Document.class}, (InvocationHandler)handler);
    }

    private static class SneakyInvocationHandler
    implements InvocationHandler {
        private final Document originalDocument;

        private SneakyInvocationHandler(Document originalDocument) {
            this.originalDocument = originalDocument;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
            if ("getDocumentElement".equals(method.getName())) {
                return this.getDocumentElement();
            }
            return method.invoke((Object)this.originalDocument, objects);
        }

        private Element getDocumentElement() {
            return this.getFirstElement(this.originalDocument);
        }

        private Element getFirstElement(Node parent) {
            NodeList nodeList = parent.getChildNodes();
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                return (Element)child;
            }
            return null;
        }
    }
}

