/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.testkit.client.restclient.Issue;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IssueKeyMatcher
extends TypeSafeMatcher<List<Issue>> {
    private final String issueKey;
    private final boolean exists;

    public static IssueKeyMatcher containsIssueWithKey(String issueKey) {
        return new IssueKeyMatcher(issueKey, true);
    }

    public static IssueKeyMatcher notContainsIssueWithKey(String issueKey) {
        return new IssueKeyMatcher(issueKey, false);
    }

    public IssueKeyMatcher(String issueKey, boolean exists) {
        this.issueKey = issueKey;
        this.exists = exists;
    }

    protected boolean matchesSafely(List<Issue> issues) {
        Issue selectedIssue = null;
        for (Issue issue : issues) {
            if (!this.issueKey.equals(issue.key)) continue;
            selectedIssue = issue;
            break;
        }
        return this.exists ? selectedIssue != null : selectedIssue == null;
    }

    public void describeTo(Description description) {
        String operator = this.exists ? " not " : "";
        description.appendText("a list of Issue " + operator + " containing " + this.issueKey);
    }
}

