/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.rest.v2.permission.PermissionJsonBean;
import com.atlassian.jira.rest.v2.permission.UserPermissionJsonBean;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PermissionMatcher {
    public static Matcher<PermissionJsonBean> key(String key) {
        return new HasKeyMatcher(key);
    }

    public static Matcher<PermissionJsonBean> name(String name) {
        return new HasNameMatcher(name);
    }

    public static Matcher<PermissionJsonBean> type(String type) {
        return new HasTypeMatcher(type);
    }

    public static Matcher<PermissionJsonBean> description(String description) {
        return new HasDescriptionMatcher(description);
    }

    public static Matcher<PermissionJsonBean> hasNotEmptyDescription() {
        return new NotEmptyDescriptionMatcher();
    }

    public static Matcher<PermissionJsonBean> id(String id) {
        return new HasIdMatcher(id);
    }

    public static Matcher<UserPermissionJsonBean> deprecatedKey(Boolean value) {
        return new NoDeprecatedKeyMatcher(value);
    }

    public static Matcher<UserPermissionJsonBean> havePermission(boolean value) {
        return new HavePermissionMatcher(value);
    }

    private static class HavePermissionMatcher
    extends TypeSafeMatcher<UserPermissionJsonBean> {
        private final boolean havePermission;

        private HavePermissionMatcher(boolean havePermission) {
            this.havePermission = havePermission;
        }

        protected boolean matchesSafely(UserPermissionJsonBean item) {
            return this.havePermission == item.havePermission;
        }

        public void describeTo(Description description) {
            description.appendText("havePermission with value: ").appendValue((Object)this.havePermission);
        }
    }

    private static class HasIdMatcher
    extends TypeSafeMatcher<PermissionJsonBean> {
        private final String id;

        private HasIdMatcher(String id) {
            this.id = id;
        }

        protected boolean matchesSafely(PermissionJsonBean item) {
            return this.id.equals(item.id());
        }

        public void describeTo(Description description) {
            description.appendText("has id with value: ").appendValue((Object)this.id);
        }
    }

    private static class NoDeprecatedKeyMatcher
    extends TypeSafeMatcher<UserPermissionJsonBean> {
        private final Boolean value;

        public NoDeprecatedKeyMatcher(Boolean value) {
            this.value = value;
        }

        protected boolean matchesSafely(UserPermissionJsonBean item) {
            return this.value == null ? item.deprecatedKey == null : this.value.equals(item.deprecatedKey);
        }

        public void describeTo(Description description) {
            description.appendText("has not deprecatedKey present");
        }
    }

    private static class NotEmptyDescriptionMatcher
    extends TypeSafeMatcher<PermissionJsonBean> {
        private NotEmptyDescriptionMatcher() {
        }

        protected boolean matchesSafely(PermissionJsonBean permissionJsonBean) {
            return StringUtils.isNotEmpty((CharSequence)permissionJsonBean.description);
        }

        public void describeTo(Description description) {
            description.appendText("description should not be empty");
        }
    }

    private static class HasDescriptionMatcher
    extends TypeSafeMatcher<PermissionJsonBean> {
        private final String description;

        public HasDescriptionMatcher(String description) {
            this.description = description;
        }

        protected boolean matchesSafely(PermissionJsonBean permissionJsonBean) {
            return this.description.equals(permissionJsonBean.description);
        }

        public void describeTo(Description description) {
            description.appendText("expected description value is: ").appendValue((Object)this.description);
        }
    }

    private static class HasTypeMatcher
    extends TypeSafeMatcher<PermissionJsonBean> {
        private final String type;

        public HasTypeMatcher(String type) {
            this.type = type;
        }

        protected boolean matchesSafely(PermissionJsonBean permissionJsonBean) {
            return this.type.equals("" + permissionJsonBean.type);
        }

        public void describeTo(Description description) {
            description.appendText("expected type value is: ").appendValue((Object)this.type);
        }
    }

    private static class HasNameMatcher
    extends TypeSafeMatcher<PermissionJsonBean> {
        private final String name;

        public HasNameMatcher(String name) {
            this.name = name;
        }

        protected boolean matchesSafely(PermissionJsonBean permissionJsonBean) {
            return this.name.equals(permissionJsonBean.name);
        }

        public void describeTo(Description description) {
            description.appendText("expected name value is: ").appendValue((Object)this.name);
        }
    }

    private static class HasKeyMatcher
    extends TypeSafeMatcher<PermissionJsonBean> {
        private final String key;

        public HasKeyMatcher(String key) {
            this.key = key;
        }

        protected boolean matchesSafely(PermissionJsonBean permissionJsonBean) {
            return this.key.equals(permissionJsonBean.key());
        }

        public void describeTo(Description description) {
            description.appendText("expected key value is: ").appendValue((Object)this.key);
        }
    }
}

