/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.StatementDecorator;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class AbstractBuildNumberRule<T extends Annotation>
implements TestRule {
    private final Class<T> annotation;
    private final BiPredicate<T, Integer> skipTestPredicate;
    private final Function<T, Integer> annotationBuildNumberFunction;
    private final Supplier<Backdoor> backdoor;

    AbstractBuildNumberRule(Supplier<Backdoor> backdoor, Class<T> annotation, BiPredicate<T, Integer> skipTestPredicate, Function<T, Integer> annotationBuildNumberFunction) {
        this.backdoor = backdoor;
        this.annotation = annotation;
        this.skipTestPredicate = skipTestPredicate;
        this.annotationBuildNumberFunction = annotationBuildNumberFunction;
    }

    public Statement apply(Statement statement, Description description) {
        Annotation methodAnnotation = description.getAnnotation(this.annotation);
        T classAnnotation = description.getTestClass().getAnnotation(this.annotation);
        Annotation annotation = Stream.of(methodAnnotation, classAnnotation).filter(Objects::nonNull).findFirst().orElse(null);
        if (annotation != null) {
            return new StatementDecorator(statement, () -> {
                int dbBuildNumber = this.backdoor.get().serverInfo().get().getDatabaseBuildNumber().intValue();
                if (this.skipTestPredicate.test(annotation, dbBuildNumber)) {
                    Assume.assumeTrue((String)this.describeUnsatisfiedRule(description.getDisplayName(), this.annotationBuildNumberFunction.apply(annotation), dbBuildNumber), (boolean)false);
                }
            });
        }
        return statement;
    }

    abstract String describeUnsatisfiedRule(String var1, int var2, int var3);
}

